/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.util.csv;

import com.pmease.quickbuild.plugin.report.engine.exception.ParseException;
import com.pmease.quickbuild.plugin.report.engine.util.csv.CSVParser;
import java.io.IOException;
import java.io.Reader;
import java.util.Collections;
import java.util.List;

public class CSVReader {
    private final Reader reader;
    private final CSVParser parser;
    private final String comment;
    private final char commentChar;
    private int lineNumber = 0;
    private final char[] buf = new char[100];
    private int bufLen = 0;
    private int bufPos = 0;
    private States state = States.Appending;

    public CSVReader(Reader reader) {
        this(reader, ',');
    }

    public CSVReader(Reader reader, char delimiter) {
        this(reader, delimiter, '#');
    }

    public CSVReader(Reader reader, char delimiter, char comment) {
        this.reader = reader;
        this.parser = new CSVParser(delimiter, true);
        this.comment = comment + "";
        this.commentChar = comment;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public List<String> readLine() throws IOException, ParseException {
        String line;
        do {
            if ((line = this.readCSVLine()) != null) continue;
            return Collections.emptyList();
        } while (line.startsWith(this.comment) || line.trim().startsWith(this.comment));
        return this.parser.tokenize(line);
    }

    public void close() throws IOException {
        this.reader.close();
    }

    private String readCSVLine() throws IOException {
        if (this.state == States.EOF) {
            return null;
        }
        StringBuilder line = new StringBuilder();
        block16: while (true) {
            if (this.bufPos >= this.bufLen) {
                this.bufPos = 0;
                this.bufLen = this.reader.read(this.buf);
                if (this.bufLen < 0) {
                    this.state = States.EOF;
                    if (line.length() != 0) {
                        ++this.lineNumber;
                        return line.toString();
                    }
                    return null;
                }
            }
            while (true) {
                if (this.bufPos >= this.bufLen) continue block16;
                char ch = this.buf[this.bufPos];
                block0 : switch (this.state) {
                    case Appending: {
                        switch (ch) {
                            case '\r': {
                                this.state = States.CarriageReturn;
                                break block0;
                            }
                            case '\n': {
                                ++this.lineNumber;
                                ++this.bufPos;
                                this.state = States.Appending;
                                return line.toString();
                            }
                            case '\"': {
                                this.state = States.InsideDoubleQuote;
                                line.append(ch);
                                break block0;
                            }
                        }
                        if (ch == this.commentChar) {
                            this.state = States.InsideComment;
                        }
                        line.append(ch);
                        break;
                    }
                    case InsideDoubleQuote: {
                        if (ch == '\"') {
                            this.state = States.EndingDoubleQuote;
                        }
                        line.append(ch);
                        break;
                    }
                    case EndingDoubleQuote: {
                        if (ch == '\"') {
                            this.state = States.InsideDoubleQuote;
                            line.append(ch);
                            break;
                        }
                        this.state = States.Appending;
                        --this.bufPos;
                        break;
                    }
                    case CarriageReturn: {
                        if (ch == '\n') {
                            ++this.bufPos;
                        }
                        ++this.lineNumber;
                        this.state = States.Appending;
                        return line.toString();
                    }
                    case InsideComment: {
                        switch (ch) {
                            case '\n': 
                            case '\r': {
                                --this.bufPos;
                                this.state = States.Appending;
                                break block0;
                            }
                        }
                        line.append(ch);
                        break;
                    }
                    case EOF: {
                        return null;
                    }
                }
                ++this.bufPos;
            }
            break;
        }
    }

    static enum States {
        Appending,
        InsideDoubleQuote,
        EndingDoubleQuote,
        CarriageReturn,
        InsideComment,
        EOF;

    }
}

