/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.util.csv;

import com.pmease.quickbuild.plugin.report.engine.exception.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CSVParser {
    private final char delimiter;
    private final boolean trimFields;

    public CSVParser() {
        this(',', true);
    }

    public CSVParser(char delimiter) {
        this(delimiter, true);
    }

    public CSVParser(char delimiter, boolean trimFields) {
        this.delimiter = delimiter;
        this.trimFields = trimFields;
    }

    public String[] parse(String line) throws ParseException {
        List<String> tokens = this.tokenize(line);
        return tokens.toArray(new String[tokens.size()]);
    }

    public List<String> tokenize(String line) throws ParseException {
        if (line == null || line.length() == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> tokens = new ArrayList<String>();
        StringBuilder tokenBuf = new StringBuilder();
        boolean insideDoubleQuote = false;
        boolean isDoubleQuoteEscapeActive = false;
        StringBuilder wspBuf = new StringBuilder();
        block4: for (int ii = 0; ii < line.length(); ++ii) {
            char ch = line.charAt(ii);
            switch (ch) {
                case '\n': 
                case '\r': {
                    if (insideDoubleQuote) {
                        tokenBuf.append(ch);
                        continue block4;
                    }
                    throw new ParseException("unquoted " + (ch == '\n' ? "newline" : "carriage return") + " found at position #" + (ii + 1));
                }
                case '\"': {
                    if (insideDoubleQuote) {
                        if (isDoubleQuoteEscapeActive) {
                            tokenBuf.append(ch);
                            isDoubleQuoteEscapeActive = false;
                            continue block4;
                        }
                        if (CSVParser.isNextCharDoubleQuote(line, ii)) {
                            isDoubleQuoteEscapeActive = true;
                            continue block4;
                        }
                        insideDoubleQuote = false;
                        continue block4;
                    }
                    insideDoubleQuote = true;
                    CSVParser.handleWhitespace(wspBuf, tokenBuf);
                    continue block4;
                }
                default: {
                    if (insideDoubleQuote) {
                        tokenBuf.append(ch);
                        continue block4;
                    }
                    if (ch == this.delimiter) {
                        tokens.add(tokenBuf.toString());
                        tokenBuf.delete(0, tokenBuf.length());
                        wspBuf.delete(0, wspBuf.length());
                        continue block4;
                    }
                    if (Character.isWhitespace(ch)) {
                        if (!this.trimFields) {
                            tokenBuf.append(ch);
                            continue block4;
                        }
                        wspBuf.append(ch);
                        continue block4;
                    }
                    CSVParser.handleWhitespace(wspBuf, tokenBuf);
                    tokenBuf.append(ch);
                }
            }
        }
        if (insideDoubleQuote) {
            throw new ParseException("terminating double quote not found");
        }
        tokens.add(tokenBuf.toString());
        return tokens;
    }

    private static void handleWhitespace(StringBuilder wspBuf, StringBuilder tokenBuf) {
        if (wspBuf.length() != 0) {
            if (tokenBuf.length() != 0) {
                tokenBuf.append((CharSequence)wspBuf);
            }
            wspBuf.delete(0, wspBuf.length());
        }
    }

    private static boolean isNextCharDoubleQuote(String line, int ii) {
        return ii + 1 < line.length() && line.charAt(ii + 1) == '\"';
    }
}

