/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.util.csv;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.pmease.quickbuild.plugin.report.engine.datatype.DataTypes;
import com.pmease.quickbuild.plugin.report.engine.extensionpoint.DataType;
import com.pmease.quickbuild.plugin.report.engine.util.csv.CSVParser;
import com.pmease.quickbuild.plugin.report.engine.util.csv.CSVWriter;
import com.pmease.quickbuild.util.BeanUtils;
import com.pmease.quickbuild.util.ExceptionUtils;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.util.ArrayList;
import org.apache.commons.io.IOUtils;

public class CSVHelper {
    private CSVHelper() {
    }

    public static <T> String asString(T obj, String ... fields) {
        if (obj == null || fields.length == 0) {
            return null;
        }
        StringWriter sw = new StringWriter();
        CSVWriter writer = new CSVWriter(sw, ':');
        try {
            ArrayList array = Lists.newArrayList();
            for (String each : fields) {
                String str;
                Field field = BeanUtils.getField(obj.getClass(), (String)each);
                field.setAccessible(true);
                Object value = field.get(obj);
                if (value == null) {
                    str = "";
                } else {
                    Class<?> type = field.getType();
                    if (type.isEnum()) {
                        str = ((Enum)value).toString();
                    } else {
                        DataType dataType = DataTypes.getDataType(type);
                        str = dataType.asString(value, null);
                    }
                }
                array.add(str);
            }
            writer.join(array);
            String string = sw.toString();
            return string;
        }
        catch (Exception e) {
            throw ExceptionUtils.wrapAsUnchecked((Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((Writer)sw);
        }
    }

    public static <T> T fromString(String str, T obj, String ... fields) {
        if (Strings.isNullOrEmpty((String)str) || fields.length == 0) {
            return obj;
        }
        String[] tokens = new CSVParser(':').parse(str);
        Preconditions.checkState((tokens.length >= fields.length ? 1 : 0) != 0);
        try {
            for (int i = 0; i < fields.length; ++i) {
                Object value;
                Field field = BeanUtils.getField(obj.getClass(), (String)fields[i]);
                field.setAccessible(true);
                Class<?> type = field.getType();
                if (type.isEnum()) {
                    value = Enum.valueOf(type, tokens[i]);
                } else {
                    DataType dataType = DataTypes.getDataType(type);
                    value = dataType.fromString(tokens[i], null);
                }
                field.set(obj, value);
            }
            return obj;
        }
        catch (Exception e) {
            throw ExceptionUtils.wrapAsUnchecked((Throwable)e);
        }
    }
}

