/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.util.csv;

import com.pmease.quickbuild.plugin.report.engine.exception.ParseException;
import com.pmease.quickbuild.util.ExceptionUtils;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;

public class CSVEscape {
    public static String escapeCSV(String text) {
        return CSVEscape.escapeCSV(text, ',');
    }

    public static String escapeCSV(String text, char delimiter) {
        try {
            StringWriter writer = new StringWriter();
            CSVEscape.escapeCSV(writer, text, delimiter);
            return writer.toString();
        }
        catch (Throwable e) {
            throw new ParseException("escapeCSV error", e);
        }
    }

    public static void escapeCSV(Writer writer, String text, char delimiter) {
        StringBuilder sbuf = new StringBuilder();
        boolean isBuffering = true;
        try {
            block6: for (int ii = 0; ii < text.length(); ++ii) {
                char ch = text.charAt(ii);
                switch (ch) {
                    case '\"': {
                        if (isBuffering) {
                            isBuffering = false;
                            writer.write(34);
                            if (sbuf.length() != 0) {
                                writer.write(sbuf.toString());
                            }
                        }
                        writer.write(34);
                        writer.write(34);
                        continue block6;
                    }
                    case '\n': 
                    case '\r': {
                        if (isBuffering) {
                            isBuffering = false;
                            writer.write(34);
                            if (sbuf.length() != 0) {
                                writer.write(sbuf.toString());
                            }
                        }
                        writer.write(ch);
                        continue block6;
                    }
                    default: {
                        if (ch == delimiter) {
                            if (isBuffering) {
                                isBuffering = false;
                                writer.write(34);
                                if (sbuf.length() != 0) {
                                    writer.write(sbuf.toString());
                                }
                            }
                            writer.write(ch);
                            continue block6;
                        }
                        if (isBuffering) {
                            sbuf.append(ch);
                            continue block6;
                        }
                        writer.write(ch);
                    }
                }
            }
            if (isBuffering) {
                writer.write(text);
            } else {
                writer.write(34);
            }
        }
        catch (IOException e) {
            throw ExceptionUtils.wrapAsUnchecked((Throwable)e);
        }
    }
}

