/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.util;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import com.pmease.quickbuild.plugin.report.engine.annotation.Alias;
import com.pmease.quickbuild.plugin.report.engine.datatype.DataTypes;
import com.pmease.quickbuild.plugin.report.engine.extensionpoint.AbstractTypedXMLObject;
import com.pmease.quickbuild.plugin.report.engine.extensionpoint.DataType;
import com.pmease.quickbuild.plugin.report.engine.extensionpoint.XMLSerializable;
import com.pmease.quickbuild.plugin.report.engine.util.TypedObjects;
import com.pmease.quickbuild.util.BeanUtils;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.util.List;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.wicket.util.io.IOUtils;
import org.apache.wicket.util.io.XmlReader;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.Node;
import org.dom4j.QName;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.xml.sax.SAXException;

public final class XMLHelper {
    private XMLHelper() {
    }

    private static boolean isXPath(String path) {
        return path.indexOf(47) >= 0;
    }

    public static String getString(Node node, String path, String defaultValue) {
        if (node == null) {
            return null;
        }
        String value = null;
        switch (node.getNodeType()) {
            case 2: {
                value = node.getStringValue();
                break;
            }
            case 1: {
                if (XMLHelper.isXPath(path)) {
                    value = node.valueOf(path);
                    break;
                }
                Element element = (Element)node;
                if (element.attribute(path) != null) {
                    value = element.attributeValue(path);
                    break;
                }
                if ((element = element.element(path)) == null) break;
                value = element.getText();
                break;
            }
            default: {
                value = node.getText();
            }
        }
        if (StringUtils.isBlank((String)value)) {
            return defaultValue;
        }
        return value;
    }

    public static String getString(Node node, String name) {
        return XMLHelper.getString(node, name, null);
    }

    public static String[] getStringArray(Node node, String path, String[] defaultValue) {
        String str = XMLHelper.getString(node, path);
        if (StringUtils.isEmpty((String)str)) {
            return defaultValue;
        }
        return (String[])Iterables.toArray((Iterable)Splitter.on((char)',').omitEmptyStrings().trimResults().split((CharSequence)str), String.class);
    }

    public static String[] getStringArray(Node node, String path) {
        return XMLHelper.getStringArray(node, path, new String[0]);
    }

    public static Boolean getBoolean(Node node, String name, Boolean defaultValue) {
        String strValue = XMLHelper.getString(node, name, null);
        if (strValue == null) {
            return defaultValue;
        }
        return (Boolean)DataTypes.BOOLEAN.fromString(strValue, null, null);
    }

    public static Integer getInt(Node node, String name, Integer defaultValue) {
        String strValue = XMLHelper.getString(node, name, null);
        if (strValue == null) {
            return defaultValue;
        }
        return (Integer)DataTypes.INTEGER.fromString(strValue, null, null);
    }

    public static Long getLong(Node node, String name, Long defaultValue) {
        String strValue = XMLHelper.getString(node, name, null);
        if (strValue == null) {
            return defaultValue;
        }
        return (Long)DataTypes.LONG.fromString(strValue, null, null);
    }

    public static Double getDouble(Node node, String name, Double defaultValue) {
        String strValue = XMLHelper.getString(node, name, null);
        if (strValue == null) {
            return defaultValue;
        }
        return (Double)DataTypes.DOUBLE.fromString(strValue, null, null);
    }

    public static <T extends Enum> T getEnum(Node node, String path, Class<T> cls) {
        String str = XMLHelper.getString(node, path);
        if (str == null) {
            return (T)((Enum[])cls.getEnumConstants())[0];
        }
        return Enum.valueOf(cls, str);
    }

    private static <T> T getXPathValue(Node node, String xpath, T defaultValue, Class<T> clazz) {
        String str = node.valueOf(xpath);
        if (StringUtils.isEmpty((String)str)) {
            return defaultValue;
        }
        DataType dataType = DataTypes.getDataType(clazz);
        return (T)dataType.fromString(str);
    }

    public static int getIntOfXPath(Node node, String xpath) {
        return XMLHelper.getXPathValue(node, xpath, 0, Integer.class);
    }

    public static long getLongOfXPath(Node node, String xpath) {
        return XMLHelper.getXPathValue(node, xpath, 0L, Long.class);
    }

    public static String getStringOfXPath(Node node, String xpath) {
        return XMLHelper.getXPathValue(node, xpath, null, String.class);
    }

    public static double getDoubleOfXPath(Node node, String xpath) {
        return XMLHelper.getXPathValue(node, xpath, 0.0, Double.class);
    }

    public static SAXReader createSAXReader(String encoding) throws SAXException {
        SAXReader reader = new SAXReader();
        reader.setEncoding(encoding);
        reader.setValidation(false);
        reader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        return reader;
    }

    public static Document readXML(InputStream in, String encoding) {
        Preconditions.checkNotNull((Object)in, (Object)"The input stream should not be null.");
        try {
            SAXReader reader = XMLHelper.createSAXReader(encoding);
            Document doc = reader.read(in);
            doc.setXMLEncoding(encoding);
            Document document = doc;
            return document;
        }
        catch (DocumentException e) {
            throw Throwables.propagate((Throwable)e);
        }
        catch (SAXException e) {
            throw Throwables.propagate((Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((Closeable)in);
        }
    }

    public static Document readXML(InputStream in) {
        return XMLHelper.readXML(in, "UTF-8");
    }

    public static Document readXML(File file) {
        String encoding = XMLHelper.getEncoding(file);
        try {
            return XMLHelper.readXML(new FileInputStream(file), encoding);
        }
        catch (FileNotFoundException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static Document readXML(String xml) {
        try {
            return DocumentHelper.parseText((String)xml);
        }
        catch (DocumentException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static void writeXML(Document doc, OutputStream out) {
        XMLWriter writer = null;
        try {
            OutputFormat outformat = OutputFormat.createPrettyPrint();
            outformat.setEncoding("UTF-8");
            writer = new XMLWriter(out, outformat);
            writer.write(doc);
            writer.flush();
        }
        catch (UnsupportedEncodingException e) {
            throw Throwables.propagate((Throwable)e);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {}
            }
            IOUtils.closeQuietly((Closeable)out);
        }
    }

    public static void writeXML(Document doc, File file) {
        try {
            XMLHelper.writeXML(doc, new FileOutputStream(file));
        }
        catch (FileNotFoundException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static XMLInputFactory getXMLInputFactory() {
        return XMLInputFactory.newInstance();
    }

    public static XMLEventReader createXMLEventReader(InputStream in) {
        try {
            return XMLHelper.getXMLInputFactory().createXMLEventReader(in, "UTF-8");
        }
        catch (XMLStreamException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static String readDocumentVersion(File xmlFile) {
        return XMLHelper.readDocumentVersion(xmlFile, "version");
    }

    public static String getEncoding(File xmlFile) {
        String string;
        FileInputStream fi = null;
        XmlReader reader = null;
        try {
            fi = new FileInputStream(xmlFile);
            reader = new XmlReader((InputStream)fi, null);
            String encoding = reader.getEncoding();
            if (Strings.isNullOrEmpty((String)encoding)) {
                encoding = "UTF-8";
            }
            string = encoding;
        }
        catch (IOException e) {
            try {
                throw Throwables.propagate((Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fi);
                IOUtils.closeQuietly(reader);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)fi);
        IOUtils.closeQuietly((Closeable)reader);
        return string;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String readDocumentVersion(File xmlFile, String versionQName) {
        block17: {
            block16: {
                in = null;
                reader = null;
                try {
                    in = new FileInputStream(xmlFile);
                    reader = XMLHelper.createXMLEventReader(in);
                    while (reader.hasNext()) {
                        event = reader.peek();
                        if (!event.isStartElement()) continue;
                        element = reader.nextEvent().asStartElement();
                        attr = element.getAttributeByName(new javax.xml.namespace.QName(versionQName));
                        if (attr == null) {
                            var7_9 = null;
                            break block16;
                        }
                        ** GOTO lbl-1000
                    }
                    break block17;
                }
                catch (Exception e) {
                    try {
                        throw Throwables.propagate((Throwable)e);
                    }
                    catch (Throwable var9_13) {
                        IOUtils.closeQuietly(in);
                        if (reader == null) throw var9_13;
                        try {
                            reader.close();
                            throw var9_13;
                        }
                        catch (XMLStreamException e) {
                            throw Throwables.propagate((Throwable)e);
                        }
                    }
                }
            }
            IOUtils.closeQuietly((Closeable)in);
            if (reader == null) return var7_9;
            try {
                reader.close();
                return var7_9;
            }
            catch (XMLStreamException e) {
                throw Throwables.propagate((Throwable)e);
            }
lbl-1000:
            // 1 sources

            {
                var7_10 = attr.getValue();
            }
            IOUtils.closeQuietly((Closeable)in);
            if (reader == null) return var7_10;
            try {
                reader.close();
                return var7_10;
            }
            catch (XMLStreamException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
        IOUtils.closeQuietly((Closeable)in);
        if (reader == null) return null;
        try {
            reader.close();
            return null;
        }
        catch (XMLStreamException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static Element reflectionToXML(AbstractTypedXMLObject object, Element node) {
        Class<?> cls = object.getClass();
        if (node == null) {
            node = DocumentHelper.createElement((String)object.getElementName());
        }
        List fields = BeanUtils.getFields(cls);
        for (Field field : fields) {
            Alias alias = field.getAnnotation(Alias.class);
            if (alias == null) continue;
            Class<?> fieldClass = field.getType();
            String nodeName = field.getName();
            if (alias != null && !StringUtils.isEmpty((String)alias.name())) {
                nodeName = alias.name();
            }
            Object value = null;
            try {
                value = PropertyUtils.getProperty((Object)object, (String)field.getName());
            }
            catch (Exception e) {
                throw Throwables.propagate((Throwable)e);
            }
            if (value == null) continue;
            if (value instanceof XMLSerializable) {
                node.add(((XMLSerializable)value).toXML());
                continue;
            }
            String text = null;
            if (value instanceof Enum) {
                text = ((Enum)value).name();
            } else {
                DataType dataType = DataTypes.getDataType(fieldClass);
                text = dataType.asString(value, null);
            }
            if (StringUtils.isEmpty((String)text)) {
                text = alias.empty();
            }
            switch (alias.type()) {
                case ELEMENT: {
                    Element fieldElement = node.addElement(nodeName);
                    if (alias.data()) {
                        fieldElement.addCDATA(text);
                        break;
                    }
                    fieldElement.setText(text);
                    break;
                }
                case ATTRIBUTE: {
                    if (StringUtils.isEmpty((String)text)) break;
                    node.addAttribute(nodeName, text);
                    break;
                }
            }
        }
        return node;
    }

    public static void reflectionFromXML(AbstractTypedXMLObject object, Element node) {
        if (node == null) {
            return;
        }
        Class<?> cls = object.getClass();
        List fields = BeanUtils.getFields(cls);
        for (Field field : fields) {
            Alias alias = field.getAnnotation(Alias.class);
            if (alias == null) continue;
            Class<?> fieldClass = field.getType();
            String nodeName = field.getName();
            if (alias != null && !StringUtils.isEmpty((String)alias.name())) {
                nodeName = alias.name();
            }
            String[] value = null;
            if (XMLSerializable.class.isAssignableFrom(fieldClass)) {
                String type = XMLHelper.getString((Node)node, "type");
                AbstractTypedXMLObject o = (AbstractTypedXMLObject)TypedObjects.createTypedObject(type, fieldClass, new Object[0]);
                Element subNode = node.element(o.getElementName());
                if (subNode != null) {
                    o.fromXML(subNode);
                }
                value = o;
            } else {
                String str = XMLHelper.getString((Node)node, nodeName, alias.empty());
                if (StringUtils.isEmpty((String)str)) continue;
                str = str.trim();
                if (fieldClass.isArray()) {
                    String[] array;
                    value = array = (String[])Iterables.toArray((Iterable)Splitter.on((String)",").trimResults().omitEmptyStrings().split((CharSequence)str), String.class);
                } else if (Enum.class.isAssignableFrom(fieldClass)) {
                    if (!StringUtils.isEmpty((String)str)) {
                        value = Enum.valueOf(fieldClass, str);
                    }
                } else {
                    value = DataTypes.getDataType(fieldClass).fromString(str, null, null);
                }
            }
            if (value == null) continue;
            try {
                boolean old = field.isAccessible();
                field.setAccessible(true);
                field.set(object, value);
                field.setAccessible(old);
            }
            catch (Exception e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
    }

    public static void fixNamespaces(Document doc) {
        Element root = doc.getRootElement();
        if (root.getNamespace() != Namespace.NO_NAMESPACE) {
            XMLHelper.removeNamespaces(root.content());
        }
    }

    public static void setNamespace(Element elem, Namespace ns) {
        elem.setQName(QName.get((String)elem.getName(), (Namespace)ns, (String)elem.getQualifiedName()));
    }

    public static void removeNamespaces(Element elem) {
        XMLHelper.setNamespaces(elem, Namespace.NO_NAMESPACE);
    }

    public static void removeNamespaces(List<Node> l) {
        XMLHelper.setNamespaces(l, Namespace.NO_NAMESPACE);
    }

    public static void setNamespaces(Element elem, Namespace ns) {
        XMLHelper.setNamespace(elem, ns);
        XMLHelper.setNamespaces(elem.content(), ns);
    }

    public static void setNamespaces(List<Node> l, Namespace ns) {
        Node n = null;
        for (int i = 0; i < l.size(); ++i) {
            n = l.get(i);
            if (n.getNodeType() == 2) {
                ((Attribute)n).setNamespace(ns);
            }
            if (n.getNodeType() != 1) continue;
            XMLHelper.setNamespaces((Element)n, ns);
        }
    }
}

