/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.util;

import com.pmease.quickbuild.AccessDeniedException;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.entitymanager.ConfigurationManager;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.security.SecurityHelper;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;

public class RestHelper {
    public static Configuration getConfigurationFromRequest(String configurationPath, Long configurationId) {
        if (Context.getUser() == null) {
            throw new AccessDeniedException();
        }
        if (StringUtils.isBlank((String)configurationPath) && configurationId == null) {
            throw new WebApplicationException(Response.status((int)400).entity((Object)"Either configuration path or configuration id should be specified").type("text/plain").build());
        }
        ConfigurationManager cm = (ConfigurationManager)Quickbuild.getInstance(ConfigurationManager.class);
        Configuration configuration = configurationId != null ? (Configuration)cm.get(configurationId) : cm.get(configurationPath);
        if (configuration == null) {
            throw new WebApplicationException(Response.status((int)404).entity((Object)"The configuration doesn't exist in Quickbuild server.").type("text/plain").build());
        }
        if (!SecurityHelper.hasPermission((Configuration)configuration)) {
            throw new WebApplicationException(Response.status((int)406).entity((Object)("The user [" + Context.getUser().getName() + "] has no permission to access configuration [" + configuration.getPathName() + "].")).type("text/plain").build());
        }
        return configuration;
    }
}

