/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.util;

import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.pmease.quickbuild.CacheManager;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.entitymanager.BuildManager;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.plugin.report.engine.datatype.DataTypes;
import com.pmease.quickbuild.plugin.report.engine.extensionpoint.DataType;
import com.pmease.quickbuild.plugin.report.engine.util.BuildFragment;
import com.pmease.quickbuild.plugin.report.engine.util.BuildUtils;
import com.pmease.quickbuild.plugin.report.engine.util.Builds;
import com.pmease.quickbuild.plugin.report.engine.util.CoverageLevel;
import com.pmease.quickbuild.plugin.report.engine.util.MathUtils;
import com.pmease.quickbuild.util.DateRange;
import com.pmease.quickbuild.util.ExceptionUtils;
import com.pmease.quickbuild.util.FileUtils;
import com.pmease.quickbuild.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.WordUtils;
import org.apache.commons.lang.time.DateUtils;
import org.apache.velocity.tools.generic.EscapeTool;
import org.apache.wicket.util.resource.IStringResourceStream;
import org.apache.wicket.util.resource.StringBufferResourceStream;
import org.hibernate.Session;

public class ReportUtils
extends StringUtils
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static ReportUtils instance = new ReportUtils();
    public static final int LIST_MAX_SIZE = 50;
    public static final int CROP_CENTER = 0;
    public static final int CROP_FROM_START = 1;
    private static char[] FILE_SEPERATORS = new char[]{'\\', '/'};
    public static final int NUM_OF_BUILDS = 50;

    public static ReportUtils getInstance() {
        return instance;
    }

    public String listAsCsv(List list) {
        return DataTypes.LIST.asString(list);
    }

    public String latestBuildsToLinks(List<Long> builds, int maxSize) {
        if (builds.size() == 0) {
            return "";
        }
        List<BuildFragment> fragments = ReportUtils.getLatestBuilds(builds, maxSize);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < fragments.size(); ++i) {
            BuildFragment fragment = fragments.get(i);
            String link = BuildUtils.getBuildUrl(fragment);
            link = "<a href=\"" + link + "\" " + ReportUtils.getBuildCssClass(fragment) + ">" + fragment.getVersion() + "</a>";
            sb.append(link);
            if (i + 1 >= fragments.size()) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    private static String getBuildCssClass(BuildFragment build) {
        return "class=\"build-status " + build.getStatus().name().toLowerCase() + "\"";
    }

    public static boolean isBuildIdValid(Long buildId) {
        return buildId != null && buildId > 0L;
    }

    public static <T> List<T> limitListSize(List<T> sourceList, int size, boolean fromStart) {
        if (sourceList == null) {
            return null;
        }
        if (sourceList.size() <= size) {
            return sourceList;
        }
        if (fromStart) {
            return new ArrayList<T>(sourceList.subList(0, size));
        }
        return new ArrayList<T>(sourceList.subList(sourceList.size() - size, sourceList.size()));
    }

    public static List limitAddingValue(List sourceList, Object value, int size, boolean fromStart) {
        if (value == null) {
            return sourceList;
        }
        if (sourceList == null) {
            sourceList = new ArrayList<Object>();
        }
        sourceList.add(value);
        return ReportUtils.limitListSize(sourceList, size, fromStart);
    }

    public static List limitAddingValue(List sourceList, Object value) {
        return ReportUtils.limitAddingValue(sourceList, value, 50, false);
    }

    public static IStringResourceStream getStringResourceStream(String template) {
        StringBufferResourceStream sb = new StringBufferResourceStream();
        sb.append((CharSequence)template);
        return sb;
    }

    public static double totals(List<Number> list) {
        if (list == null || list.size() == 0) {
            return 0.0;
        }
        double totals = 0.0;
        for (Number n : list) {
            totals += n == null ? 0.0 : n.doubleValue();
        }
        return totals;
    }

    public static double average(List<Number> list) {
        if (list == null || list.size() == 0) {
            return 0.0;
        }
        double totals = ReportUtils.totals(list);
        return totals / (double)list.size();
    }

    public static Number max(List<Number> list) {
        if (list == null || list.size() == 0) {
            return 0.0;
        }
        Number max = Double.MIN_VALUE;
        for (Number n : list) {
            if (!(max < n.doubleValue())) continue;
            max = n;
        }
        return max;
    }

    public static Number min(List<Number> list) {
        if (list == null || list.size() == 0) {
            return 0.0;
        }
        Number min = Double.MAX_VALUE;
        for (Number n : list) {
            if (!(min > n.doubleValue())) continue;
            min = n;
        }
        return min;
    }

    public static String getCoverageColor(Number coverage) {
        return CoverageLevel.fromNumber(coverage).getColor();
    }

    public static String getPriorityColor(String priority) {
        if ("HIGH".equalsIgnoreCase(priority)) {
            return "#FF1A00";
        }
        if ("MEDIUM".equalsIgnoreCase(priority)) {
            return "#FF7400";
        }
        if ("NORMAL".equalsIgnoreCase(priority)) {
            return "#CCB800";
        }
        return "#00AA99";
    }

    public static String cropText(String str, int cropLength) {
        return ReportUtils.wrapText(str, cropLength, null, true);
    }

    public static String cropText(String str, int cropLength, int position) {
        return ReportUtils.wrapText(str, cropLength, null, true, position);
    }

    public static String wrapText(String str, int wrapLength) {
        return ReportUtils.wrapText(str, wrapLength, null);
    }

    public static String wrapText(String str, int wrapLength, String newLineStr) {
        return ReportUtils.wrapText(str, wrapLength, newLineStr, false);
    }

    public static String wrapText(String str, int wrapLength, String newLineStr, boolean cropWord) {
        return ReportUtils.wrapText(str, wrapLength, newLineStr, cropWord, 0);
    }

    public static String wrapText(String str, int wrapLength, String newLineStr, boolean cropWord, int cropPosition) {
        if (str == null || str.length() < wrapLength) {
            return str;
        }
        if (wrapLength < 1) {
            return str;
        }
        if (!cropWord) {
            return WordUtils.wrap((String)str, (int)wrapLength, (String)newLineStr, (boolean)true);
        }
        if (cropPosition == 1) {
            return "..." + str.substring(str.length() - wrapLength);
        }
        int length = (wrapLength - 3) / 2;
        if (length < 1) {
            length = 1;
        }
        String firstPart = str.substring(0, length);
        String lastPart = str.substring(str.length() - length, str.length());
        return firstPart + "..." + lastPart;
    }

    public static String wrapAsHtmlMultiline(String str, int wrapLength, String newLineStr, boolean cropWord, int cropPosition, boolean escapeHtml) {
        if (StringUtils.isEmpty((String)str)) {
            return "";
        }
        String result = ReportUtils.wrapText(str, wrapLength, newLineStr, cropWord, cropPosition);
        if (escapeHtml) {
            result = new EscapeTool().html((Object)result);
        }
        result = ReportUtils.replaceSpaceToHtmlCode(result);
        return result;
    }

    public static String replaceSpaceToHtmlCode(String original) {
        if (StringUtils.isEmpty((String)original)) {
            return "";
        }
        String result = StringUtils.replace((String)original, (String)"\n", (String)"<br/>");
        result = StringUtils.replace((String)result, (String)"\t", (String)"&nbsp;&nbsp;&nbsp;&nbsp;");
        return StringUtils.replace((String)result, (String)"  ", (String)"&nbsp;&nbsp;");
    }

    public static String wrapAsHtmlMultiline(String str, int wrapLength, String newLineStr, boolean escapeHtml) {
        return ReportUtils.wrapAsHtmlMultiline(str, wrapLength, newLineStr, false, 0, escapeHtml);
    }

    public static String wrapAsHtmlMultiline(String str, int wrapLength, String newLineStr) {
        return ReportUtils.wrapAsHtmlMultiline(str, wrapLength, newLineStr, true);
    }

    public static String wrapAsHtmlMultiline(String str, int wrapLength) {
        return ReportUtils.wrapAsHtmlMultiline(str, wrapLength, " ");
    }

    public static String wrapAsHtmlMultiline(String str, int wrapLength, boolean escapeHtml) {
        return ReportUtils.wrapAsHtmlMultiline(str, wrapLength, " ", escapeHtml);
    }

    public static String escapeHtml(String raw) {
        return new EscapeTool().html((Object)raw);
    }

    public static String classNameToFileName(String className) {
        if (StringUtils.isEmpty((String)className)) {
            return null;
        }
        int pos = className.indexOf(36);
        if (pos > 0) {
            className = className.substring(0, pos);
        }
        String fileName = className.replaceAll("\\.", "/");
        fileName = fileName + ".java";
        return fileName;
    }

    public static String classNameToFileName(String packageName, String className) {
        String name = "";
        if (!StringUtils.isEmpty((String)packageName)) {
            name = name + packageName + ".";
        }
        if (!StringUtils.isEmpty((String)className)) {
            name = name + className;
        }
        return ReportUtils.classNameToFileName(name);
    }

    public static String getPackageFromMethodName(String methodName) {
        return ReportUtils.splitMethodName(methodName)[0];
    }

    public static String getClassFromMethodName(String methodName) {
        return ReportUtils.splitMethodName(methodName)[1];
    }

    public static String getMethodFromMethodName(String methodName) {
        return ReportUtils.splitMethodName(methodName)[2];
    }

    public static String getMethodSignature(String methodName) {
        if (ReportUtils.isEmpty((String)methodName)) {
            return null;
        }
        int pos = methodName.indexOf(40);
        String params = pos > 0 ? methodName.substring(pos) : "()";
        return ReportUtils.getMethodFromMethodName(methodName) + params;
    }

    public static String getClassNameFromFilePath(String filePath) {
        if (StringUtils.isEmpty((String)filePath)) {
            return null;
        }
        String fileName = ReportUtils.getFileName(filePath);
        int pos = fileName.lastIndexOf(".");
        if (pos > 0) {
            return fileName.substring(0, pos);
        }
        return fileName;
    }

    public static String getRelativePath(List<String> sourcePaths, String relativePath, String workspacePath) {
        if (StringUtils.isEmpty((String)relativePath)) {
            return null;
        }
        if (sourcePaths == null || sourcePaths.size() == 0) {
            return ReportUtils.getRelativePath(relativePath, workspacePath);
        }
        String absolutePath = null;
        for (String path : sourcePaths) {
            File file = new File(path, relativePath);
            if (!file.exists()) continue;
            absolutePath = file.getAbsolutePath();
            break;
        }
        if (absolutePath == null) {
            return relativePath;
        }
        return ReportUtils.getRelativePath(absolutePath, workspacePath);
    }

    public static String getRelativePath(String absolutePath, String workspacePath) {
        return ReportUtils.getRelativePath(absolutePath, workspacePath, true);
    }

    public static String getRelativePath(String absolutePath, String workspacePath, boolean convertToCanonicalPath) {
        String relativePath;
        if (StringUtils.isEmpty((String)absolutePath)) {
            return null;
        }
        if (StringUtils.isEmpty((String)workspacePath)) {
            return absolutePath;
        }
        if (!org.apache.tools.ant.util.FileUtils.isAbsolutePath((String)absolutePath)) {
            return absolutePath;
        }
        if (convertToCanonicalPath) {
            File file1 = new File(absolutePath);
            File file2 = new File(workspacePath);
            try {
                String canonicalPath1 = file1.getCanonicalPath();
                String canonicalPath2 = file2.getCanonicalPath();
                relativePath = FileUtils.getRelativePath((String)canonicalPath1, (String)canonicalPath2);
            }
            catch (IOException e) {
                throw ExceptionUtils.wrapAsUnchecked((Throwable)e);
            }
        } else {
            relativePath = FileUtils.getRelativePath((String)absolutePath, (String)workspacePath);
        }
        if (StringUtils.isEmpty((String)relativePath)) {
            return absolutePath;
        }
        return relativePath;
    }

    public static String concatPath(String path1, String path2) {
        if (StringUtils.isEmpty((String)path1)) {
            return path2;
        }
        if (StringUtils.isEmpty((String)path2)) {
            return path1;
        }
        char c = path1.charAt(path1.length() - 1);
        if (ArrayUtils.contains((char[])FILE_SEPERATORS, (char)c)) {
            path1 = path1.substring(0, path1.length() - 1);
        }
        if (ArrayUtils.contains((char[])FILE_SEPERATORS, (char)(c = path2.charAt(0)))) {
            path2 = path2.substring(1);
        }
        for (int i = 0; i < path1.length() && !ArrayUtils.contains((char[])FILE_SEPERATORS, (char)(c = path1.charAt(i))); ++i) {
        }
        char sep2 = '/';
        for (int i = 0; i < path2.length() && !ArrayUtils.contains((char[])FILE_SEPERATORS, (char)(sep2 = path2.charAt(i))); ++i) {
        }
        if (c != sep2) {
            path2 = path2.replace(sep2, c);
        }
        return path1 + c + path2;
    }

    public static String getPackageNameFromClassName(String className) {
        return ReportUtils.splitClassName(className)[0];
    }

    public static String getClassNameFromClassName(String className) {
        return ReportUtils.splitClassName(className)[1];
    }

    public static String[] splitClassName(String className) {
        String[] result = new String[]{"", ""};
        if (StringUtils.isEmpty((String)className)) {
            return result;
        }
        int pos = className.lastIndexOf(".");
        if (pos > 0) {
            result[0] = className.substring(0, pos);
            result[1] = className.substring(pos + 1);
        } else {
            result[1] = className;
        }
        return result;
    }

    public static String[] splitCsv(String str) {
        if (Strings.isNullOrEmpty((String)str)) {
            return new String[0];
        }
        return (String[])Iterables.toArray((Iterable)Splitter.on((char)',').omitEmptyStrings().trimResults().split((CharSequence)str), String.class);
    }

    public static String getFileName(String path) {
        int pos = path.lastIndexOf(47);
        if (pos > 0) {
            return path.substring(pos + 1);
        }
        pos = path.lastIndexOf(92);
        if (pos > 0) {
            return path.substring(pos + 1);
        }
        return path;
    }

    public static String getFilePath(String path) {
        int pos = path.lastIndexOf(47);
        if (pos > 0) {
            return path.substring(0, pos);
        }
        pos = path.lastIndexOf(92);
        if (pos > 0) {
            return path.substring(0, pos);
        }
        return path;
    }

    public static String[] splitMethodName(String methodName) {
        String[] result = new String[]{"", "", ""};
        if (StringUtils.isEmpty((String)methodName)) {
            return result;
        }
        int index = methodName.indexOf("(");
        if (index > 0) {
            methodName = methodName.substring(0, index);
        }
        index = methodName.lastIndexOf(".");
        String className = null;
        if (index <= 0) {
            result[2] = methodName;
            return result;
        }
        className = methodName.substring(0, index);
        result[2] = methodName.substring(index + 1);
        String[] packageClass = ReportUtils.splitClassName(className);
        result[0] = packageClass[0];
        result[1] = packageClass[1];
        return result;
    }

    public static List<String> getCommitters(Build build, String path, boolean exactly) {
        if (StringUtils.isEmpty((String)path) || build == null) {
            return Collections.emptyList();
        }
        List committers = exactly ? build.getCommitters(path) : build.getCommitters(path, exactly);
        ArrayList<String> realNames = new ArrayList<String>();
        for (String committer : committers) {
            int pos = committer.indexOf(58);
            if (pos > 0) {
                committer = committer.substring(pos + 1);
            }
            realNames.add(committer);
        }
        return realNames;
    }

    public static List<String> findCommittersByClassName(Build build, String className) {
        return ReportUtils.getCommitters(build, ReportUtils.classNameToFileName(className), false);
    }

    public static List<String> findCommittersByClassName(Build build, String packageName, String className) {
        return ReportUtils.getCommitters(build, ReportUtils.classNameToFileName(packageName, className), false);
    }

    public static Builds findBuilds(Long configurationId, DateRange dateRange, boolean excludingFailed) {
        return BuildUtils.findBuilds(configurationId, dateRange, excludingFailed);
    }

    public static long currentBuildCount() {
        return CacheManager.instance.getHistoryCount(Context.getConfiguration().getId());
    }

    public static String buildIdsToVersions(List<Long> buildIds) {
        if (buildIds.size() == 0) {
            return "";
        }
        ArrayList<String> versions = new ArrayList<String>();
        BuildManager buildManager = (BuildManager)Quickbuild.getInstance(BuildManager.class);
        for (Long buildId : buildIds) {
            Build build = (Build)buildManager.get(buildId);
            if (build == null) continue;
            versions.add(build.getVersion());
        }
        return DataTypes.LIST.asString(versions, ", ");
    }

    public static BuildFragment getBuildFragment(Long buildId) {
        return BuildUtils.getBuildFragment(buildId);
    }

    public static boolean isValidBuild(Long buildId) {
        return BuildUtils.getBuildFragment(buildId) != null;
    }

    public static BuildFragment getBuildFragment(Long buildId, Session session) {
        return BuildUtils.getBuildFragment(buildId, session);
    }

    public static String hyperlinkBuild(BuildFragment build) {
        return ReportUtils.hyperlinkBuild(build, 0);
    }

    public static String hyperlinkBuild(BuildFragment build, int cropLength) {
        return BuildUtils.hyperlinkBuild(build, cropLength, 0);
    }

    public static String hyperlinkBuild(BuildFragment build, int cropLength, int cropPosition) {
        return BuildUtils.hyperlinkBuild(build, cropLength, cropPosition);
    }

    public static String getBuildUrl(BuildFragment build) {
        return BuildUtils.getBuildUrl(build);
    }

    public static String getBuildUrl(Long buildId) {
        return BuildUtils.getBuildUrl(buildId);
    }

    public static String hyperlinkBuild(Long buildId) {
        return BuildUtils.hyperlinkBuild(buildId);
    }

    public static String getReportsetUrl(Build build, String tabName, String subTab, String reportset) {
        StringBuffer sb = new StringBuffer();
        sb.append(build.getUrl()).append("/").append(tabName).append("/").append(subTab);
        try {
            if (!Strings.isNullOrEmpty((String)reportset)) {
                sb.append("?reportset=").append(URLEncoder.encode(reportset, Charsets.UTF_8.toString()));
            }
        }
        catch (UnsupportedEncodingException e) {
            throw Throwables.propagate((Throwable)e);
        }
        return sb.toString();
    }

    public static String getBuildVersion(Long buildId) {
        return BuildUtils.getBuildVersion(buildId);
    }

    public static Builds getBuilds(List<Long> buildIds, int maxSize) {
        return BuildUtils.getBuilds(buildIds, maxSize);
    }

    public static List<BuildFragment> getBuilds(Configuration configuration, Date fromDate, Date toDate) {
        return BuildUtils.getBuilds(configuration, fromDate, toDate);
    }

    public static List<BuildFragment> getLatestBuilds(Configuration configuration, int maxSize) {
        return BuildUtils.getLatestBuilds(configuration, maxSize);
    }

    public static List<BuildFragment> getLatestBuilds(List<Long> buildIds, int maxSize) {
        Collections.reverse(buildIds);
        return BuildUtils.getBuilds(buildIds, maxSize);
    }

    public static List<BuildFragment> getLatestBuilds(List<Long> buildIds, int max, List<String> statuses, String acceptStatus) {
        return BuildUtils.getLatestBuilds(buildIds, max, statuses, acceptStatus);
    }

    public static Builds getBuilds(Configuration c, Long from, Long to, int size) {
        return BuildUtils.getBuilds(c, from, to, size);
    }

    public static boolean isSameDay(Object lhs, Object rhs) {
        Date date2;
        Date date1 = (Date)DataTypes.DATE.typeCast(lhs);
        if (Objects.equal((Object)date1, (Object)(date2 = (Date)DataTypes.DATE.typeCast(rhs)))) {
            return true;
        }
        return DateUtils.isSameDay((Date)date1, (Date)date2);
    }

    public static String joinIterables(Iterable<?> iterable) {
        return ReportUtils.joinIterables(iterable, ", ");
    }

    public static String joinIterables(Iterable<?> iterable, String separator) {
        if (iterable == null || !iterable.iterator().hasNext()) {
            return "";
        }
        return Joiner.on((String)separator).skipNulls().join(iterable);
    }

    public static String format(Object obj, String pattern) {
        if (obj == null) {
            return "N/A";
        }
        DataType dataType = DataTypes.getDataType(obj);
        if (pattern == null) {
            return dataType.asString(obj);
        }
        return dataType.asString(obj, pattern);
    }

    public static String format(Object obj, String type, String pattern) {
        if (obj == null) {
            return "N/A";
        }
        DataType dataType = DataTypes.getDataType(type);
        if (pattern == null) {
            return dataType.asString(obj);
        }
        return dataType.asString(obj, pattern);
    }

    public static String formatDuration(Object obj) {
        return ReportUtils.format(obj, DataTypes.DURATION.getType(), null);
    }

    public static String firstOf(String str, int length) {
        if (ReportUtils.isEmpty((String)str)) {
            return "NA";
        }
        if (str.length() <= length) {
            return str;
        }
        return str.substring(0, length);
    }

    public static <T> T getFirst(Iterable<T> iterable, T defaultValue) {
        return (T)Iterables.getFirst(iterable, defaultValue);
    }

    public static <T> T getLast(Iterable<T> iterable, T defaultValue) {
        return (T)Iterables.getLast(iterable, defaultValue);
    }

    public static double divide(Number part, Number total) {
        return MathUtils.divide(part, total);
    }

    public static double divide(int part, int total) {
        return MathUtils.divide(part, total);
    }

    public static String formatJUnitMessageAsHtml(String original) {
        if (StringUtils.isEmpty((String)original)) {
            return "";
        }
        ArrayList messages = Lists.newArrayList((Iterable)Splitter.on((String)"___QB__LINE__SEP___").omitEmptyStrings().split((CharSequence)original));
        StringBuffer sb = new StringBuffer();
        if (messages.size() > 1) {
            sb.append("<ol>");
            int i = 0;
            for (String each : messages) {
                String s = StringEscapeUtils.escapeHtml((String)each);
                sb.append("<li><pre>").append(s).append("</pre></li>");
                if (i++ <= 5) continue;
                break;
            }
            if (messages.size() > 5) {
                sb.append("<p>...</p>");
            }
        } else {
            sb.append("<pre>").append(StringEscapeUtils.escapeHtml((String)original)).append("</pre>");
        }
        return sb.toString();
    }
}

