/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.util;

import com.google.common.base.Preconditions;
import com.pmease.quickbuild.plugin.report.engine.datatype.DataTypes;
import com.pmease.quickbuild.plugin.report.engine.extensionpoint.DataType;
import com.pmease.quickbuild.util.BeanUtils;
import com.pmease.quickbuild.util.ExceptionUtils;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MapHelper {
    private MapHelper() {
    }

    public static Map<String, Object> beanToMap(Object obj) {
        if (obj == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        List fields = BeanUtils.getFields(obj.getClass());
        for (Field each : fields) {
            String name = each.getName();
            each.setAccessible(true);
            try {
                map.put(name, each.get(obj));
            }
            catch (IllegalArgumentException e) {
                throw ExceptionUtils.wrapAsUnchecked((Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw ExceptionUtils.wrapAsUnchecked((Throwable)e);
            }
        }
        return map;
    }

    public static void mapToBean(Map<String, Object> map, Object obj) {
        Preconditions.checkNotNull((Object)obj, (Object)"Bean object should be null");
        List fields = BeanUtils.getFields(obj.getClass());
        for (Field each : fields) {
            String name = each.getName();
            Object value = map.get(name);
            if (value == null) continue;
            DataType dataType = DataTypes.getDataType(each.getType());
            value = dataType.typeCast(value);
            each.setAccessible(true);
            try {
                each.set(obj, value);
            }
            catch (IllegalArgumentException e) {
                throw ExceptionUtils.wrapAsUnchecked((Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw ExceptionUtils.wrapAsUnchecked((Throwable)e);
            }
        }
    }

    public static int getInt(Map<String, Object> map, String key, Integer defaultValue) {
        return MapHelper.getObject(map, key, Integer.valueOf(defaultValue));
    }

    public static int getInt(Map<String, Object> map, String key) {
        return MapHelper.getInt(map, key, new Integer(0));
    }

    public static double getDouble(Map<String, Object> map, String key, Double defaultValue) {
        return MapHelper.getObject(map, key, defaultValue);
    }

    public static double getDouble(Map<String, Object> map, String key) {
        return MapHelper.getDouble(map, key, new Double(0.0));
    }

    public static long getLong(Map<String, Object> map, String key, Long defaultValue) {
        return MapHelper.getObject(map, key, defaultValue);
    }

    public static long getLong(Map<String, Object> map, String key) {
        return MapHelper.getLong(map, key, new Long(0L));
    }

    public static <T> T getObject(Map<String, Object> map, String key, T defaultValue) {
        if (map == null) {
            return defaultValue;
        }
        Object value = map.get(key);
        if (value == null) {
            return defaultValue;
        }
        return (T)value;
    }
}

