/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.util;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.plugin.report.engine.datatype.DataTypes;
import com.pmease.quickbuild.plugin.report.engine.util.ReportUtils;
import com.pmease.quickbuild.util.ExceptionUtils;
import com.pmease.quickbuild.util.FileUtils;
import com.pmease.quickbuild.util.LockUtils;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.locks.Lock;

public class LastBuildsFile {
    private final File dir;
    private List<Long> buildIds = Lists.newArrayList();

    public LastBuildsFile(File dir) {
        this.dir = dir;
    }

    public void add(Build build) {
        this.buildIds = ReportUtils.limitAddingValue(this.buildIds, build.getId());
    }

    public File getFile() {
        return new File(this.dir, "latest.id");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        Lock lock = LockUtils.lockForWrite((File)this.getFile());
        try {
            Collections.sort(this.buildIds);
            this.buildIds = ReportUtils.limitListSize(this.buildIds, 50, false);
            FileUtils.writeFile((File)this.getFile(), (String)DataTypes.LIST_LONG.asString(this.buildIds, null));
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        File file = this.getFile();
        if (!file.exists()) {
            return;
        }
        Lock lock = LockUtils.lockForRead((File)file);
        try {
            String str = FileUtils.readFileAsString((File)this.getFile());
            if (Strings.isNullOrEmpty((String)str)) {
                return;
            }
            List ids = (List)DataTypes.LIST_LONG.fromString(str, null);
            for (Long each : ids) {
                if (each == null) continue;
                this.buildIds.add(each);
            }
        }
        catch (Exception e) {
            Throwable t = ExceptionUtils.extractException((Throwable)e, IOException.class);
            if (t == null) {
                throw ExceptionUtils.wrapAsUnchecked((Throwable)e);
            }
        }
        finally {
            lock.unlock();
        }
    }

    public List<Long> getBuildIds() {
        return this.buildIds;
    }

    public void setBuildIds(List<Long> buildIds) {
        this.buildIds = buildIds;
    }
}

