/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.util;

import org.joda.time.format.ISOPeriodFormat;
import org.joda.time.format.PeriodFormatter;
import org.joda.time.format.PeriodFormatterBuilder;

public class DurationFormatUtils {
    static PeriodFormatter wordFormatter = new PeriodFormatterBuilder().appendYears().appendSuffix(" year", " years").appendSeparator(" ").appendMonths().appendSuffix(" month", " months").appendSeparator(" ").appendDays().appendSuffix(" day", " days").appendSeparator(" ").appendHours().appendSuffix(" hour", " hours").appendSeparator(" ").appendMinutes().appendSuffix(" minute", " minutes").appendSeparator(" ").appendSeconds().appendSuffix(" second", " seconds").appendSeparator(" ").appendMillis3Digit().toFormatter();
    static PeriodFormatter shortWordFormatter = new PeriodFormatterBuilder().appendDays().appendSuffix("d").appendSeparator(", ").appendHours().appendSuffix("h").appendSeparator(":").appendMinutes().appendSuffix("m").appendSeparator(":").appendSeconds().appendSuffix("s").appendSeparator(", ").appendMillis().toFormatter();
    static PeriodFormatter timeFormatter = new PeriodFormatterBuilder().printZeroAlways().appendHours().appendSuffix(":").appendMinutes().appendSuffix(":").appendSeconds().toFormatter();

    public static PeriodFormatter createPeriodFormatter(String pattern) {
        PeriodFormatterBuilder builder = new PeriodFormatterBuilder();
        DurationFormatUtils.parsePatternTo(builder, pattern);
        return builder.toFormatter();
    }

    private static void parsePatternTo(PeriodFormatterBuilder builder, String pattern) {
        int length = pattern.length();
        int[] indexRef = new int[1];
        builder.printZeroAlways();
        block9: for (int i = 0; i < length; ++i) {
            indexRef[0] = i;
            String token = DurationFormatUtils.parseToken(pattern, indexRef);
            i = indexRef[0];
            int tokenLen = token.length();
            if (tokenLen == 0) break;
            char c = token.charAt(0);
            switch (c) {
                case 'y': {
                    builder.appendYears();
                    continue block9;
                }
                case 'd': {
                    builder.minimumPrintedDigits(tokenLen);
                    builder.appendDays();
                    continue block9;
                }
                case 'H': {
                    builder.minimumPrintedDigits(tokenLen);
                    builder.appendHours();
                    continue block9;
                }
                case 'm': {
                    builder.minimumPrintedDigits(tokenLen);
                    builder.appendMinutes();
                    continue block9;
                }
                case 's': {
                    builder.minimumPrintedDigits(tokenLen);
                    builder.appendSeconds();
                    continue block9;
                }
                case 'S': {
                    builder.minimumPrintedDigits(tokenLen);
                    builder.appendMillis();
                    continue block9;
                }
                case '\'': {
                    String sub = token.substring(1);
                    builder.appendLiteral(new String(sub));
                    continue block9;
                }
                default: {
                    throw new IllegalArgumentException("Illegal pattern component: " + token);
                }
            }
        }
    }

    private static String parseToken(String pattern, int[] indexRef) {
        int i;
        StringBuffer buf = new StringBuffer();
        int length = pattern.length();
        char c = pattern.charAt(i);
        if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z') {
            char peek;
            buf.append(c);
            while (i + 1 < length && (peek = pattern.charAt(i + 1)) == c) {
                buf.append(c);
                ++i;
            }
        } else {
            buf.append('\'');
            boolean inLiteral = false;
            for (i = indexRef[0]; i < length; ++i) {
                c = pattern.charAt(i);
                if (c == '\'') {
                    if (i + 1 < length && pattern.charAt(i + 1) == '\'') {
                        ++i;
                        buf.append(c);
                        continue;
                    }
                    inLiteral = !inLiteral;
                    continue;
                }
                if (inLiteral || (c < 'A' || c > 'Z') && (c < 'a' || c > 'z')) {
                    buf.append(c);
                    continue;
                }
                break;
            }
        }
        indexRef[0] = --i;
        return buf.toString();
    }

    public static PeriodFormatter isoFormatter() {
        return ISOPeriodFormat.standard();
    }

    public static PeriodFormatter wordFormatter() {
        return wordFormatter;
    }

    public static PeriodFormatter shortWordFormatter() {
        return shortWordFormatter;
    }

    public static PeriodFormatter getTimeFormatter() {
        return timeFormatter;
    }
}

