/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.util;

import com.google.common.base.Objects;
import com.pmease.quickbuild.annotation.Color;
import com.pmease.quickbuild.annotation.Editable;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.validator.constraints.NotEmpty;
import org.hibernate.validator.constraints.Range;

public class CoverageLevel
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String levelName;
    private double threshold;
    private String color;
    @XStreamOmitField
    private static List<CoverageLevel> levels = new ArrayList<CoverageLevel>();

    public CoverageLevel() {
    }

    public CoverageLevel(String name, double threshold, String color) {
        this.levelName = name;
        this.threshold = threshold;
        this.color = color;
    }

    @Editable(name="Coverage Threshold", description="Specify the threshold of the coverage.")
    @Range(min=0L, max=1L)
    public double getThreshold() {
        return this.threshold;
    }

    public void setThreshold(double threshold) {
        this.threshold = threshold;
    }

    @Editable(name="Display Color", description="Input the color in CSS format, for example: #FF0000")
    @Color
    @NotEmpty
    public String getColor() {
        return this.color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public String getLevelName() {
        return this.levelName;
    }

    public void setLevelName(String levelName) {
        this.levelName = levelName;
    }

    public static CoverageLevel fromNumber(Number number) {
        if (number == null) {
            return levels.get(levels.size() - 1);
        }
        for (CoverageLevel level : levels) {
            if (!(number.doubleValue() >= level.getThreshold())) continue;
            return level;
        }
        return levels.get(levels.size() - 1);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("Name", (Object)this.levelName).add("Threshold", this.threshold).add("Color", (Object)this.color).toString();
    }

    static {
        levels.add(new CoverageLevel("HIGH", 0.9, "#008C00"));
        levels.add(new CoverageLevel("MEDIUM", 0.7, "#999966"));
        levels.add(new CoverageLevel("NORMAL", 0.5, "#FF7400"));
        levels.add(new CoverageLevel("LOW", 0.0, "#FF1A00"));
    }
}

