/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.util;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.wicket.util.lang.Objects;

public class CaseInsensitiveMap<V>
implements Map<String, V>,
Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private Map<String, String> originalKeys = new HashMap<String, String>();
    private final Map<String, V> delegate;

    public static <V> CaseInsensitiveMap<V> create() {
        return CaseInsensitiveMap.create(new HashMap());
    }

    public static <V> CaseInsensitiveMap<V> create(Map<String, V> delegate, Map<String, V> from) {
        CaseInsensitiveMap<V> result = CaseInsensitiveMap.create(delegate);
        result.putAll(from);
        return result;
    }

    public static <V> CaseInsensitiveMap<V> create(Map<String, V> delegate) {
        return new CaseInsensitiveMap<V>(delegate);
    }

    public static <V> CaseInsensitiveMap<V> of(Map<String, V> from) {
        CaseInsensitiveMap<V> result = CaseInsensitiveMap.create();
        result.putAll(from);
        return result;
    }

    protected CaseInsensitiveMap(Map<String, V> delegate) {
        this.delegate = delegate;
    }

    public String getOriginalKey(String key) {
        return this.originalKeys.get(key.toLowerCase());
    }

    public Collection<String> getOriginalKeys() {
        return this.originalKeys.values();
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        String s = key.toString().toLowerCase();
        return this.delegate.containsKey(s);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.delegate.containsValue(value);
    }

    @Override
    public V get(Object key) {
        String s = key.toString().toLowerCase();
        return this.delegate.get(s);
    }

    @Override
    public V put(String key, V value) {
        String s = key.toLowerCase();
        this.originalKeys.put(s, key);
        return this.delegate.put(s, value);
    }

    @Override
    public V remove(Object key) {
        String s = key.toString().toLowerCase();
        this.originalKeys.remove(s);
        return this.delegate.remove(s);
    }

    @Override
    public void putAll(Map<? extends String, ? extends V> t) {
        for (Map.Entry<String, V> entry : t.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        this.delegate.clear();
        this.originalKeys.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.delegate.keySet();
    }

    @Override
    public Collection<V> values() {
        return this.delegate.values();
    }

    @Override
    public Set<Map.Entry<String, V>> entrySet() {
        return this.delegate.entrySet();
    }

    @Override
    public boolean equals(Object other) {
        if (other == null || !(other instanceof Map)) {
            return false;
        }
        CaseInsensitiveMap<V> rhs = CaseInsensitiveMap.create((Map)other);
        for (String each : this.keySet()) {
            if (Objects.equal(this.get(each), rhs.get(each))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        return ((Object)this.delegate).hashCode();
    }

    public String toString() {
        return this.delegate.toString();
    }
}

