/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.util;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.plugin.report.engine.util.BuildFragment;
import java.util.ArrayList;
import java.util.List;

public class Builds
extends ArrayList<BuildFragment> {
    private static final long serialVersionUID = 1L;
    private int successes;
    private int failed;
    private int cancelled;
    private BiMap<Long, Integer> indexIdMap = HashBiMap.create();

    public Builds() {
    }

    public Builds(List<BuildFragment> list) {
        super(list);
    }

    public Builds(int size) {
        super(size);
    }

    @Override
    public boolean add(BuildFragment build) {
        boolean b = super.add(build);
        if (b && build != null) {
            this.increase(build.getStatus());
        }
        this.indexIdMap.put((Object)build.getId(), (Object)(this.size() - 1));
        return b;
    }

    public boolean remove(BuildFragment build) {
        boolean b = super.remove(build);
        if (b && build != null) {
            this.decrease(build.getStatus());
        }
        this.indexIdMap.remove((Object)build.getId());
        return b;
    }

    @Override
    public BuildFragment remove(int index) {
        BuildFragment b = (BuildFragment)super.remove(index);
        this.indexIdMap.inverse().remove((Object)index);
        if (b != null) {
            this.decrease(b.getStatus());
        }
        return b;
    }

    public BuildFragment getBuild(Long id) {
        Integer i = (Integer)this.indexIdMap.get((Object)id);
        if (i != null) {
            return (BuildFragment)this.get(i);
        }
        return null;
    }

    public BuildFragment getFrom() {
        if (this.isEmpty()) {
            return null;
        }
        return (BuildFragment)this.get(0);
    }

    public BuildFragment getTo() {
        if (this.isEmpty()) {
            return null;
        }
        return (BuildFragment)this.get(this.size() - 1);
    }

    private void increase(Build.Status status) {
        if (status == Build.Status.SUCCESSFUL || status == Build.Status.RECOMMENDED) {
            ++this.successes;
        } else if (status == Build.Status.FAILED) {
            ++this.failed;
        } else if (status == Build.Status.CANCELLED || status == Build.Status.TIMEOUT) {
            ++this.cancelled;
        }
    }

    private void decrease(Build.Status status) {
        if (status == Build.Status.SUCCESSFUL || status == Build.Status.RECOMMENDED) {
            --this.successes;
        } else if (status == Build.Status.FAILED) {
            --this.failed;
        } else if (status == Build.Status.CANCELLED || status == Build.Status.TIMEOUT) {
            --this.cancelled;
        }
    }

    public int getSuccesses() {
        return this.successes;
    }

    public void setSuccesses(int successes) {
        this.successes = successes;
    }

    public int getFailed() {
        return this.failed;
    }

    public void setFailed(int failed) {
        this.failed = failed;
    }

    public int getCancelled() {
        return this.cancelled;
    }

    public void setCancelled(int cancelled) {
        this.cancelled = cancelled;
    }
}

