/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.util;

import com.google.common.base.Strings;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.SearchCriteria;
import com.pmease.quickbuild.entitymanager.BuildManager;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.persistence.SessionManager;
import com.pmease.quickbuild.plugin.report.engine.datatype.DataTypes;
import com.pmease.quickbuild.plugin.report.engine.util.BuildFragment;
import com.pmease.quickbuild.plugin.report.engine.util.Builds;
import com.pmease.quickbuild.plugin.report.engine.util.ReportUtils;
import com.pmease.quickbuild.plugin.report.engine.util.csv.CSVParser;
import com.pmease.quickbuild.util.DateRange;
import com.pmease.quickbuild.util.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.joda.time.MutableDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuildUtils {
    static final Logger logger = LoggerFactory.getLogger(BuildUtils.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Build getPrevious(Build.Status status) {
        try {
            Session session = SessionManager.openSession();
            Query query = session.createQuery("select id, status from Build where configuration.id=:configurationId and id<:buildId and status=:status order by id desc");
            query.setParameter("configurationId", (Object)Context.getConfiguration().getId());
            query.setParameter("buildId", (Object)Context.getBuild().getId());
            query.setParameter("status", (Object)status);
            query.setMaxResults(1);
            Object[] values = (Object[])query.uniqueResult();
            if (values == null) {
                Build build = null;
                return build;
            }
            Build build = (Build)((BuildManager)Quickbuild.getInstance(BuildManager.class)).get((Long)values[0]);
            return build;
        }
        finally {
            SessionManager.closeSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BuildFragment getNextBuild(Long buildId, Configuration configuration) {
        try {
            Session session = SessionManager.openSession();
            if (session == null) {
                throw new QuickbuildException("Session can only be fetched in a transactional execution environment.");
            }
            String attributes = BuildFragment.getHQLStringForBuildFragment();
            String qStr = "select " + attributes + " from Build b where (b.configuration = :configuration) and b.id > :buildId ";
            Query query = session.createQuery(qStr);
            query.setParameter("configuration", (Object)configuration);
            query.setParameter("buildId", (Object)buildId);
            query.setMaxResults(1);
            Object[] values = (Object[])query.uniqueResult();
            if (values == null) {
                BuildFragment buildFragment = null;
                return buildFragment;
            }
            BuildFragment buildFragment = new BuildFragment(values);
            return buildFragment;
        }
        finally {
            SessionManager.closeSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<BuildFragment> getLatestBuilds(Configuration configuration, int maxSize) {
        if (configuration == null) {
            return Collections.emptyList();
        }
        try {
            Session session = SessionManager.openSession();
            String attributes = BuildFragment.getHQLStringForBuildFragment();
            attributes = attributes + ", b.configuration.id";
            String qStr = "select " + attributes + " from Build b where b.configuration = :configuration order by b.id desc";
            Query q = session.createQuery(qStr);
            q.setParameter("configuration", (Object)configuration);
            if (maxSize > 0) {
                q.setMaxResults(maxSize);
            } else {
                q.setMaxResults(50);
            }
            List values = q.list();
            ArrayList<BuildFragment> builds = new ArrayList<BuildFragment>();
            for (Object[] value : values) {
                BuildFragment build = new BuildFragment(value);
                builds.add(build);
            }
            ArrayList<BuildFragment> arrayList = builds;
            return arrayList;
        }
        finally {
            SessionManager.closeSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Builds getBuilds(Configuration c, Long from, Long to, int size) {
        try {
            Session session = SessionManager.openSession();
            if (session == null) {
                throw new QuickbuildException("Session can only be fetched in a transactional execution environment.");
            }
            String attributes = BuildFragment.getHQLStringForBuildFragment();
            attributes = attributes + ", b.configuration.id";
            String qStr = "select " + attributes + " from Build b where b.configuration = :configuration and b.id >= :from and b.id <= :to order by b.id";
            Query query = session.createQuery(qStr);
            query.setParameter("configuration", (Object)c);
            query.setParameter("from", (Object)from);
            query.setParameter("to", (Object)to);
            if (size > 0) {
                query.setMaxResults(size);
            }
            List result = query.list();
            Builds builds = new Builds();
            for (Object[] each : result) {
                BuildFragment build = new BuildFragment(each);
                builds.add(build);
            }
            Builds builds2 = builds;
            return builds2;
        }
        finally {
            SessionManager.closeSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<BuildFragment> getLatestBuilds(List<Long> buildIds, int max, List<String> statuses, String acceptStatus) {
        try {
            if (StringUtils.isEmpty((String)acceptStatus)) {
                List<BuildFragment> list = Collections.emptyList();
                return list;
            }
            Session session = SessionManager.openSession();
            ArrayList<BuildFragment> builds = new ArrayList<BuildFragment>();
            int size = Math.min(buildIds.size(), statuses.size());
            Collections.reverse(buildIds);
            Collections.reverse(statuses);
            String[] acceptables = new CSVParser().parse(acceptStatus);
            for (int i = 0; i < size; ++i) {
                String status = statuses.get(i);
                if (status == null) continue;
                for (String acceptable : acceptables) {
                    Long buildId;
                    BuildFragment build;
                    if (!status.equalsIgnoreCase(acceptable) || (build = BuildUtils.getBuildFragment(buildId = buildIds.get(i), session)) == null) continue;
                    builds.add(build);
                    break;
                }
                if (builds.size() >= max) break;
            }
            ArrayList<BuildFragment> arrayList = builds;
            return arrayList;
        }
        finally {
            SessionManager.closeSession();
        }
    }

    public static List<Build> getPreviousBuildsUntil(Build until, int count) {
        SearchCriteria crit = SearchCriteria.builder().add((Criterion)Restrictions.eq((String)"configuration", (Object)until.getConfiguration())).add((Criterion)Restrictions.le((String)"id", (Object)until.getId())).add(Order.desc((String)"id")).build();
        return BuildManager.instance.search(crit, 0, count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<BuildFragment> getBuilds(Configuration configuration, Date fromDate, Date toDate) {
        if (configuration == null) {
            return Collections.emptyList();
        }
        try {
            Session session = SessionManager.openSession();
            String attributes = BuildFragment.getHQLStringForBuildFragment();
            attributes = attributes + ", b.configuration.id";
            String qStr = "select " + attributes + " from Build b where b.configuration = :configuration " + "and b.beginDate >= :beginDate and b.beginDate <= :endDate order by b.id desc";
            Query q = session.createQuery(qStr);
            q.setParameter("configuration", (Object)configuration);
            q.setParameter("beginDate", (Object)fromDate);
            q.setParameter("endDate", (Object)toDate);
            List values = q.list();
            ArrayList<BuildFragment> builds = new ArrayList<BuildFragment>();
            for (Object[] value : values) {
                BuildFragment build = new BuildFragment(value);
                builds.add(build);
            }
            ArrayList<BuildFragment> arrayList = builds;
            return arrayList;
        }
        finally {
            SessionManager.closeSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Builds getBuilds(List<Long> buildIds, int maxSize) {
        try {
            Session session = SessionManager.openSession();
            Builds builds = new Builds();
            for (Long buildId : buildIds) {
                BuildFragment buildFragment = BuildUtils.getBuildFragment(buildId, session);
                if (buildFragment == null) continue;
                builds.add(buildFragment);
                if (maxSize <= 0 || builds.size() < maxSize) continue;
                break;
            }
            Builds builds2 = builds;
            return builds2;
        }
        finally {
            SessionManager.closeSession();
        }
    }

    public static String getBuildVersion(Long buildId) {
        BuildFragment build = BuildUtils.getBuildFragment(buildId);
        if (build == null) {
            return null;
        }
        return build.getVersion();
    }

    public static String hyperlinkBuild(Long buildId) {
        BuildFragment build = BuildUtils.getBuildFragment(buildId);
        if (build == null) {
            return "<span class='red'>Non-exist build: #" + buildId + "</span>";
        }
        return ReportUtils.hyperlinkBuild(build);
    }

    public static String getBuildUrl(Long buildId) {
        return "/build/" + buildId;
    }

    public static String getBuildUrl(BuildFragment build) {
        if (build == null) {
            return "/";
        }
        return "/build/" + build.getId();
    }

    public static String hyperlinkBuild(BuildFragment build) {
        return BuildUtils.hyperlinkBuild(build, 0, 1);
    }

    public static String hyperlinkBuild(BuildFragment build, int cropLength, int cropPosition) {
        if (build == null) {
            return "<span class='red'>N/A</span>";
        }
        StringBuffer sb = new StringBuffer();
        sb.append("<a href=\"").append(BuildUtils.getBuildUrl(build)).append("\" class=\"build-status ").append(build.getStatus().name().toLowerCase()).append("\">");
        String version = build.getVersion();
        if (Strings.isNullOrEmpty((String)version)) {
            sb.append("<span class='red'>N/A</span>");
        } else if (cropLength > 0) {
            version = ReportUtils.cropText(version, cropLength, cropPosition);
        } else {
            sb.append(version);
        }
        sb.append("</a>");
        return sb.toString();
    }

    public static BuildFragment getBuildFragment(Long buildId, Session session) {
        if (session == null) {
            throw new QuickbuildException("Session can only be fetched in a transactional execution environment.");
        }
        String attributes = BuildFragment.getHQLStringForBuildFragment();
        String qStr = "select " + attributes + " from Build b where b.id = :buildId";
        Query query = session.createQuery(qStr);
        query.setParameter("buildId", (Object)buildId);
        Object[] values = (Object[])query.uniqueResult();
        if (values == null) {
            return null;
        }
        BuildFragment build = new BuildFragment(values);
        return build;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BuildFragment getBuildFragment(Long buildId) {
        try {
            Session session = SessionManager.openSession();
            BuildFragment buildFragment = BuildUtils.getBuildFragment(buildId, session);
            return buildFragment;
        }
        finally {
            SessionManager.closeSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Builds findBuilds(Long configurationId, DateRange dateRange, boolean excludingFailed) {
        try {
            long start = System.currentTimeMillis();
            Session session = SessionManager.openSession();
            if (session == null) {
                throw new QuickbuildException("Session can only be fetched in a transactional execution environment.");
            }
            String attributes = BuildFragment.getHQLStringForBuildFragment();
            String qStr = "select " + attributes + " from Build b where (b.configuration.id = :configId) ";
            if (dateRange != null) {
                qStr = qStr + " and (b.beginDate >= :beginDate) and (b.beginDate < :endDate)";
            }
            qStr = excludingFailed ? qStr + " and ((b.status = :success) or (b.status = :recommended))" : qStr + "  and ((b.status = :success) or (b.status = :failed) or (b.status = :recommended))";
            qStr = qStr + " order by b.id";
            if (logger.isDebugEnabled()) {
                logger.debug("HQL for findBuilds: " + qStr);
            }
            Query query = session.createQuery(qStr);
            query.setParameter("configId", (Object)configurationId);
            if (dateRange != null) {
                MutableDateTime dt = new MutableDateTime((Object)dateRange.getBeginDate());
                dt.setHourOfDay(0);
                dt.setMinuteOfHour(0);
                dt.setSecondOfMinute(0);
                query.setParameter("beginDate", (Object)dt.toDate());
                dt = new MutableDateTime((Object)dateRange.getEndDate());
                dt.addDays(1);
                dt.setHourOfDay(0);
                dt.setMinuteOfHour(0);
                dt.setSecondOfMinute(0);
                query.setParameter("endDate", (Object)dt.toDate());
            }
            if (!excludingFailed) {
                query.setParameter("failed", (Object)Build.Status.FAILED);
            }
            query.setParameter("success", (Object)Build.Status.SUCCESSFUL);
            query.setParameter("recommended", (Object)Build.Status.RECOMMENDED);
            Builds builds = new Builds();
            List list = query.list();
            for (Object[] values : list) {
                if (values == null) continue;
                BuildFragment build = new BuildFragment(values);
                builds.add(build);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("builds size: " + builds.size());
                logger.debug("Duration for findBuilds " + DataTypes.DURATION.asString(System.currentTimeMillis() - start));
            }
            Builds builds2 = builds;
            return builds2;
        }
        finally {
            SessionManager.closeSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasBuild(Long id) {
        Session session = SessionManager.openSession();
        if (session == null) {
            throw new QuickbuildException("Session can only be fetched in a transactional execution environment.");
        }
        try {
            Query q = session.createQuery("SELECT b.id from Build b where b.id=:id");
            q.setParameter("id", (Object)id);
            Long r = (Long)q.uniqueResult();
            boolean bl = r != null;
            return bl;
        }
        finally {
            SessionManager.closeSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Long> findBuildIds(Long configId, Long from, Long to, int maxResults) {
        Session session = SessionManager.openSession();
        if (session == null) {
            throw new QuickbuildException("Session can only be fetched in a transactional execution environment.");
        }
        try {
            Query q = session.createQuery("SELECT b.id from Build b where b.configuration.id = :configId and b.id >=:from and b.id <=:to");
            q.setParameter("configId", (Object)configId);
            q.setParameter("from", (Object)from);
            q.setParameter("to", (Object)to);
            q.setMaxResults(maxResults);
            List list = q.list();
            return list;
        }
        finally {
            SessionManager.closeSession();
        }
    }
}

