/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.util;

import com.google.common.base.Objects;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.entitymanager.UserManager;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.model.User;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.io.Serializable;
import java.util.Date;
import org.apache.commons.lang.Validate;

@XStreamAlias(value="build")
public class BuildFragment
implements Serializable,
Comparable<BuildFragment> {
    private static final long serialVersionUID = 1L;
    private Long id;
    private String version;
    private Build.Status status;
    private Date beginDate;
    private Long duration;
    private boolean scheduled;
    private String requester;
    private boolean deleted;
    public static final String[] ATTRIBUTES = new String[]{"id", "version", "status", "beginDate", "duration", "scheduled", "requester"};

    public BuildFragment() {
    }

    public Build toBuild() {
        Build build = new Build();
        build.setId(this.id);
        build.setVersion(this.version);
        build.setBeginDate(this.beginDate);
        build.setDuration(this.duration);
        build.setScheduled(this.scheduled);
        return build;
    }

    public BuildFragment(Build build) {
        this.id = build.getId();
        this.version = build.getVersion();
        this.beginDate = build.getBeginDate();
        this.duration = build.getDuration();
        this.requester = build.getRequesterName();
        this.status = build.getStatus();
        this.scheduled = build.isScheduled();
    }

    public BuildFragment(Object[] values) {
        Validate.isTrue((values != null && values.length >= 7 ? 1 : 0) != 0, (String)"The length of values for building BuildFragment should contain at least 7 parameters.");
        this.setId((Long)values[0]);
        this.setVersion((String)values[1]);
        this.setStatus((Build.Status)values[2]);
        this.setBeginDate((Date)values[3]);
        this.setDuration((Long)values[4]);
        this.setScheduled((Boolean)values[5]);
        Long userId = (Long)values[6];
        if (this.isScheduled()) {
            this.setRequester("scheduler");
        } else if (userId == null) {
            this.setRequester("unknown");
        } else {
            User u = (User)((UserManager)Quickbuild.getInstance(UserManager.class)).get(userId);
            if (u == null) {
                this.setRequester("unknown");
            } else {
                this.setRequester(u.getDisplayName());
            }
        }
    }

    public static String getHQLStringForBuildFragment() {
        String attributes = "";
        for (int i = 0; i < ATTRIBUTES.length - 1; ++i) {
            if (i > 0) {
                attributes = attributes + ",";
            }
            attributes = attributes + "b." + ATTRIBUTES[i];
        }
        attributes = attributes + ", b.requester.id";
        return attributes;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public Build.Status getStatus() {
        return this.status;
    }

    public void setStatus(Build.Status status) {
        this.status = status;
    }

    public Date getBeginDate() {
        return this.beginDate;
    }

    public void setBeginDate(Date beginDate) {
        this.beginDate = beginDate;
    }

    public Long getDuration() {
        return this.duration;
    }

    public void setDuration(Long duration) {
        this.duration = duration;
    }

    public Date getEndDate() {
        if (this.getDuration() == null) {
            return null;
        }
        return new Date(this.getBeginDate().getTime() + this.getDuration());
    }

    public String getRequester() {
        return this.requester;
    }

    public void setRequester(String triggeredBy) {
        this.requester = triggeredBy;
    }

    public boolean isScheduled() {
        return this.scheduled;
    }

    public void setScheduled(boolean isScheduled) {
        this.scheduled = isScheduled;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    @Override
    public int compareTo(BuildFragment o) {
        return this.id.compareTo(o.id);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !(other instanceof BuildFragment)) {
            return false;
        }
        BuildFragment rhs = (BuildFragment)other;
        return Objects.equal((Object)this.getId(), (Object)rhs.getId());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getId()});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("Id:", (Object)this.getId()).add("Version:", (Object)this.getVersion()).add("Status:", (Object)this.getStatus()).toString();
    }
}

