/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.rest;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.pmease.quickbuild.bootstrap.Bootstrap;
import com.pmease.quickbuild.plugin.report.engine.ReportHelper;
import com.pmease.quickbuild.plugin.report.engine.rest.BaseReportRest;
import com.pmease.quickbuild.plugin.report.engine.rest.ParamsHelp;
import com.pmease.quickbuild.plugin.report.engine.rest.RestFunction;
import com.pmease.quickbuild.plugin.report.engine.rest.RestHelp;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import org.apache.commons.lang.StringUtils;

public class RestUtils {
    public static String getBaseUri(Class<?> clazz) {
        Path path = clazz.getAnnotation(Path.class);
        Preconditions.checkNotNull((Object)path, (Object)"Not a valid Rest class");
        return "/rest" + path.value();
    }

    public static String generateHelp(Class<?> clazz) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        return RestUtils.generateHelp(clazz, RestUtils.getHelpTemplate(), map);
    }

    public static String generateHelp(Class<?> clazz, String template, Map<String, Object> context) {
        Method[] methods = clazz.getMethods();
        ArrayList functions = Lists.newArrayList();
        String baseUri = RestUtils.getBaseUri(clazz);
        for (Method each : methods) {
            if (!RestUtils.isRestFunction(each)) continue;
            Path path = each.getAnnotation(Path.class);
            RestFunction func = new RestFunction();
            String subPath = null;
            if (path != null) {
                subPath = path.value();
            }
            if (Strings.isNullOrEmpty(subPath)) {
                func.setUri(baseUri);
            } else {
                func.setUri(baseUri + subPath);
            }
            RestHelp help = each.getAnnotation(RestHelp.class);
            if (help != null) {
                func.setDescription(help.value());
            } else {
                func.setDescription("");
            }
            ParamsHelp paramshelp = each.getAnnotation(ParamsHelp.class);
            if (paramshelp != null) {
                func.setParams(paramshelp);
            }
            functions.add(func);
        }
        Collections.sort(functions, new Comparator<RestFunction>(){

            @Override
            public int compare(RestFunction o1, RestFunction o2) {
                return o1.getUri().compareTo(o2.getUri());
            }
        });
        context.put("docroot", Bootstrap.docroot);
        context.put("functions", functions);
        String html = ReportHelper.evaluateVelocity(template, context);
        html = StringUtils.replace((String)html, (String)"$docroot", (String)Bootstrap.docroot);
        return html;
    }

    private static boolean isRestFunction(Method method) {
        return method.isAnnotationPresent(Path.class) || method.isAnnotationPresent(GET.class) || method.isAnnotationPresent(POST.class) || method.isAnnotationPresent(DELETE.class);
    }

    private static String getHelpTemplate() {
        return ReportHelper.readClassResource(BaseReportRest.class, "help.vm");
    }
}

