/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.rest;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.pmease.quickbuild.AccessDeniedException;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.entitymanager.BuildManager;
import com.pmease.quickbuild.entitymanager.ConfigurationManager;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.plugin.report.engine.contribution.AbstractReportPlugin;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataReport;
import com.pmease.quickbuild.plugin.report.engine.datareport.ReportGroup;
import com.pmease.quickbuild.plugin.report.engine.datareport.ReportMetaData;
import com.pmease.quickbuild.plugin.report.engine.datastore.DbStore;
import com.pmease.quickbuild.plugin.report.engine.datastore.SqlBuilder;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.Filter;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.Restrictions;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.SearchCriterion;
import com.pmease.quickbuild.plugin.report.engine.extensionpoint.DataType;
import com.pmease.quickbuild.plugin.report.engine.metadata.CategoryDb;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.rest.ParamHelp;
import com.pmease.quickbuild.plugin.report.engine.rest.ParamType;
import com.pmease.quickbuild.plugin.report.engine.rest.ParamsHelp;
import com.pmease.quickbuild.plugin.report.engine.rest.RestHelp;
import com.pmease.quickbuild.plugin.report.engine.rest.RestUtils;
import com.pmease.quickbuild.pluginsupport.Plugin;
import com.pmease.quickbuild.pluginsupport.PluginManager;
import com.pmease.quickbuild.security.SecurityHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseReportRest {
    static final Logger logger = LoggerFactory.getLogger(BaseReportRest.class);
    static final String CONFIGURATION_PATH = "PATH:";

    protected ReportCategory getCategory() {
        Plugin plugin = PluginManager.instance.getDeclaringPlugin(this.getClass());
        if (plugin instanceof AbstractReportPlugin) {
            return ((AbstractReportPlugin)plugin).getReportCategory();
        }
        throw new QuickbuildException("The plugin " + plugin.getClass() + " is not inherit from AbstractReportPlugin, or Rest class " + this.getClass() + " doesn't belong to the plugin. You have to override getCategory().");
    }

    protected String getBaseUri() {
        Path path = this.getClass().getAnnotation(Path.class);
        return "/rest" + path.value();
    }

    protected String getUri(Path path) {
        return this.getBaseUri() + path.value();
    }

    @Path(value="/help")
    @Produces(value={"text/html"})
    @RestHelp(value="List all RESTful functions")
    @GET
    public String help(@QueryParam(value="xml") Boolean xml) {
        return RestUtils.generateHelp(this.getClass());
    }

    @Path(value="/version")
    @Produces(value={"text/plain"})
    @RestHelp(value="Return the version of this category")
    @GET
    public String getVersion() {
        String version = this.getCategory().getVersion();
        return version;
    }

    @Path(value="/reports")
    @RestHelp(value="Return all reports defined in this category. ")
    @GET
    public List<String> getReportNames() {
        ReportMetaData[] metas = this.getCategory().getMetas();
        ArrayList names = Lists.newArrayList();
        for (ReportMetaData each : metas) {
            names.add(each.getReportName());
        }
        return names;
    }

    @Path(value="/meta/{name}")
    @Produces(value={"text/xml"})
    @RestHelp(value="Get the meta data for a specific report.")
    @ParamsHelp(value={@ParamHelp(name="name", required=true, type=ParamType.PATH_PARAM, description="The name of report")})
    @GET
    public String getMeta(@PathParam(value="name") String name) {
        return this.findMetaData(name).toXML().asXML();
    }

    @Path(value="/reportsets/{report_group}/{configuration_or_build_id}")
    @RestHelp(value="Return the reportsets for a specific group. ")
    @ParamsHelp(value={@ParamHelp(name="report_group", type=ParamType.PATH_PARAM, description="Specify the report group. It can be one of the following: BUILD, STATISTICS, HISTORY, AGGREGATION"), @ParamHelp(name="configuration_or_build_id", type=ParamType.PATH_PARAM, description="For BUILD group, the id should be a valid build id, otherwise, the configuration id should be specified.")})
    @GET
    public List<String> getReportSets(@PathParam(value="report_group") ReportGroup group, @PathParam(value="configuration_or_build_id") Long id) {
        ReportCategory category = this.getCategory();
        if (group == ReportGroup.BUILD) {
            Build build = this.getBuild(id);
            return Lists.newArrayList((Object[])category.getReportSetsOfBuild(build));
        }
        if (group == ReportGroup.AGGREGATION) {
            Configuration c = this.getConfiguration(id);
            return Lists.newArrayList((Object[])category.getReportSetsOfAggregation(c));
        }
        Configuration c = this.getConfiguration(id);
        return Lists.newArrayList((Object[])category.getReportSetsOfStats(c));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Path(value="/size/{name}/{configuration_or_build_id}/{reportset}")
    @Produces(value={"text/plain"})
    @RestHelp(value="Get the number of total records of a specified report.")
    @ParamsHelp(value={@ParamHelp(name="name", type=ParamType.PATH_PARAM, description="Specify the report name"), @ParamHelp(name="configuration_or_build_id", type=ParamType.PATH_PARAM, description="According to the report you specified, the id is build id when report belongs to BUILD group, otherwise, configuration id is needed."), @ParamHelp(name="reportset", type=ParamType.PATH_PARAM, description="The report set or aggregation name"), @ParamHelp(name="filters", type=ParamType.QUERY_PARAM, description="Specify filters based on SQL to filter the records, for example, duration>5 and duration<10, the fields available can be found in the report meta data definition.")})
    @GET
    public Long size(@PathParam(value="name") String name, @PathParam(value="configuration_or_build_id") Long id, @PathParam(value="reportset") String reportset, @Context UriInfo ui) {
        ReportCategory category = this.getCategory();
        ReportMetaData meta = category.getMeta(name);
        if (meta == null) {
            throw BaseReportRest.buildException("Cannot find meta data for report " + name + " in category " + category.getName());
        }
        File reportDir = this.getReportDir(meta.getGroup(), id, reportset);
        if (!reportDir.exists()) {
            logger.warn("No report directory : " + reportDir + " exists.");
            return 0L;
        }
        SqlBuilder query = SqlBuilder.query().select("COUNT(*)").from(name);
        MultivaluedMap queryParams = ui.getQueryParameters();
        if (queryParams.size() > 0) {
            ArrayList filters = Lists.newArrayList();
            for (String each : queryParams.keySet()) {
                if (each.equalsIgnoreCase("filters")) {
                    query.where((String)((List)queryParams.get((Object)each)).get(0));
                    continue;
                }
                if (!meta.hasColumn(each)) continue;
                DataType dataType = meta.getColumn(each).getDataType();
                List list = (List)queryParams.get((Object)each);
                SearchCriterion f = Restrictions.eq(each, dataType.fromString((String)list.get(0), null));
                filters.add(f);
            }
            query.where(filters);
        }
        CategoryDb db = category.getCategoryDb(reportDir);
        try {
            db.open(DbStore.Mode.READ_ONLY, "BaseReportRest::size");
            Long l = db.queryForLong(query);
            return l;
        }
        finally {
            db.close();
        }
    }

    @Path(value="/records/{name}/{configuration_or_build_id}/{reportset}")
    @Produces(value={"text/xml"})
    @RestHelp(value="Get the report records in XML format.")
    @ParamsHelp(value={@ParamHelp(name="name", type=ParamType.PATH_PARAM, description="Specify the report name."), @ParamHelp(name="configuration_or_build_id", type=ParamType.PATH_PARAM, description="According to the report you specified, the id is a build id when report belongs to BUILD group, otherwise, configuration id is needed."), @ParamHelp(name="reportset", type=ParamType.PATH_PARAM, description="The report set or aggregation name"), @ParamHelp(name="offset", description="The first record you want to retrieve. By default, the offset is 0, i.e., from the first record."), @ParamHelp(name="limit", description="The number of records you want to retrieve. By default, the number of limit is 50."), @ParamHelp(name="filters", type=ParamType.QUERY_PARAM, description="Specify filters based on SQL to filter the records, for example, duration>5 and duration<10, the fields available can be found in the report meta data definition.")})
    @GET
    public String getReportRecords(@PathParam(value="configuration_or_build_id") Long id, @PathParam(value="reportset") String reportset, @PathParam(value="name") String name, @Context UriInfo ui) {
        ReportCategory category = this.getCategory();
        ReportMetaData meta = this.findMetaData(name);
        File reportDir = this.getReportDir(meta.getGroup(), id, reportset);
        logger.debug("Accessing report database [" + reportDir + "] via REST ...");
        if (!reportDir.exists()) {
            logger.warn("No report directory : " + reportDir + " exists.");
            DataReport report = category.createReport(name);
            return report.toXML().asXML();
        }
        MultivaluedMap queryParams = ui.getQueryParameters();
        SqlBuilder query = SqlBuilder.query().select("*").from(name);
        ArrayList filters = Lists.newArrayList();
        int offset = 0;
        int limit = 50;
        if (queryParams.size() > 0) {
            for (String each : queryParams.keySet()) {
                if (each.equalsIgnoreCase("filters")) {
                    filters.add(Restrictions.directSql((String)queryParams.getFirst((Object)each)));
                    continue;
                }
                if ("offset".equalsIgnoreCase(each)) {
                    offset = Integer.valueOf((String)queryParams.getFirst((Object)each));
                    continue;
                }
                if ("limit".equalsIgnoreCase(each)) {
                    limit = Integer.valueOf((String)queryParams.getFirst((Object)each));
                    continue;
                }
                if (!meta.hasColumn(each)) continue;
                DataType dataType = meta.getColumn(each).getDataType();
                List list = (List)queryParams.get((Object)each);
                SearchCriterion f = Restrictions.eq(each, dataType.fromString((String)list.get(0), null));
                filters.add(f);
            }
        }
        query.where(filters).offset(offset).limit(limit);
        DataReport report = category.loadReport(reportDir, query);
        if (logger.isDebugEnabled()) {
            logger.debug("Total " + report.getRowsCount() + " rows found");
        }
        return report.toXML().asXML();
    }

    @Path(value="/buildstats/{build_id}/{reportset}")
    @Produces(value={"text/xml"})
    @RestHelp(value="Get the build stats of a specific report set.")
    @ParamsHelp(value={@ParamHelp(name="build_id", type=ParamType.PATH_PARAM, description="Specify the build id."), @ParamHelp(name="reportset", type=ParamType.PATH_PARAM, description="Specify the report set you want")})
    @GET
    public String getBuildStats(@PathParam(value="build_id") Long buildId, @PathParam(value="reportset") String reportset) {
        Build build;
        ReportCategory category = this.getCategory();
        File dir = category.getReportDirOfBuild(build = this.getBuild(buildId), reportset);
        if (!dir.exists()) {
            logger.warn("No report directory : " + dir + " exists.");
        }
        DataReport report = category.loadReport(dir, this.getBuildStatsReportName(), new Filter[0]);
        return report.toXML().asXML();
    }

    protected String getBuildStatsReportName() {
        return "stats";
    }

    ReportMetaData findMetaData(String reportName) {
        if (Strings.isNullOrEmpty((String)reportName)) {
            throw BaseReportRest.buildException("Report name should be specified");
        }
        ReportCategory category = this.getCategory();
        ReportMetaData meta = category.getMeta(reportName);
        if (meta == null) {
            throw BaseReportRest.buildException("Cannot find meta data for report " + reportName + " in category " + category.getName());
        }
        return meta;
    }

    protected void checkPermission(Configuration c) {
        if (!SecurityHelper.hasPermission((Configuration)c, (String)this.getCategory().getName().toUpperCase())) {
            throw new AccessDeniedException("You have no permission to accesss report category: " + this.getCategory().getName() + ", configuration: " + c);
        }
    }

    protected Build getBuild(Long id) {
        Build build = (Build)((BuildManager)Quickbuild.getInstance(BuildManager.class)).get(id);
        if (build == null) {
            throw BaseReportRest.buildException("Unable to find build " + id);
        }
        this.checkPermission(build.getConfiguration());
        return build;
    }

    protected Configuration getConfiguration(String configuration) {
        Configuration c;
        ConfigurationManager cm = (ConfigurationManager)Quickbuild.getInstance(ConfigurationManager.class);
        try {
            Long id = Long.valueOf(configuration);
            c = (Configuration)cm.get(id);
        }
        catch (NumberFormatException e) {
            String path = configuration;
            c = cm.get(path);
        }
        if (c == null) {
            throw BaseReportRest.buildException("Configuration [" + configuration + "] doesn't exist");
        }
        this.checkPermission(c);
        return c;
    }

    protected Configuration getConfiguration(Long id) {
        Configuration configuration = (Configuration)((ConfigurationManager)Quickbuild.getInstance(ConfigurationManager.class)).get(id);
        if (configuration == null) {
            throw BaseReportRest.buildException("Unable to find configuration " + id);
        }
        this.checkPermission(configuration);
        return configuration;
    }

    protected File getCategoryDir(ReportGroup group, Long id) {
        if (group == ReportGroup.BUILD) {
            Build build = this.getBuild(id);
            return this.getCategory().getCategoryDirOfBuild(build);
        }
        if (group == ReportGroup.AGGREGATION) {
            Configuration c = this.getConfiguration(id);
            return this.getCategory().getCategoryDirOfAggregation(c);
        }
        Configuration c = this.getConfiguration(id);
        return this.getCategory().getCategoryDirOfStats(c);
    }

    protected File getReportDir(ReportGroup group, Long id, String reportset) {
        if (group == ReportGroup.BUILD) {
            Build build = this.getBuild(id);
            return this.getCategory().getReportDirOfBuild(build, reportset);
        }
        if (group == ReportGroup.AGGREGATION) {
            Configuration c = this.getConfiguration(id);
            return this.getCategory().getReportDirOfAggregation(c, reportset);
        }
        Configuration c = this.getConfiguration(id);
        return this.getCategory().getReportDirOfStats(c, reportset);
    }

    protected static WebApplicationException buildException(String msg) {
        return BaseReportRest.buildException(400, msg);
    }

    protected static WebApplicationException buildException(int status, String msg) {
        return new WebApplicationException(Response.status((int)status).entity((Object)msg).type("text/plain").build());
    }
}

