/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.renderer.xunit;

import com.google.common.collect.Lists;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataReport;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.datatype.DataTypes;
import com.pmease.quickbuild.plugin.report.engine.renderer.AbstractReportPanel;
import com.pmease.quickbuild.plugin.report.engine.renderer.RendererContext;
import com.pmease.quickbuild.plugin.report.engine.renderer.xunit.LatestStatusRenderer;
import com.pmease.quickbuild.plugin.report.engine.util.BuildUtils;
import com.pmease.quickbuild.plugin.report.engine.util.MathUtils;
import com.pmease.quickbuild.plugin.report.engine.web.BuildWithInfoPanel;
import com.pmease.quickbuild.util.Pair;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class LatestStatusPanel
extends AbstractReportPanel {
    private static final long serialVersionUID = 1L;
    static final int MAX_SIZE = 50;

    public LatestStatusPanel(String id, LatestStatusRenderer renderer, IModel<RendererContext> model) {
        super(id, renderer, model);
    }

    @Override
    public void onInitialize() {
        super.onInitialize();
        DataReport report = this.loadDefaultReport();
        if (report.isEmpty()) {
            this.add(new Component[]{new WebMarkupContainer("blocks").setVisible(false)});
            this.add(new Component[]{new Label("successRate", "0%")});
            this.add(new Component[]{new Label("runs", "0")});
            this.add(new Component[]{new Label("failures", "0")});
        } else {
            DataRow row = report.getRow(0);
            LatestStatusRenderer renderer = (LatestStatusRenderer)this.getRenderer();
            int runs = row.getInt(renderer.getRunsColumn());
            int failures = row.getInt(renderer.getFailuresColumn());
            double successRate = MathUtils.divide(runs - failures, runs);
            Label label = new Label("successRate", DataTypes.PERCENT.asString(successRate));
            if (failures == 0) {
                label.add(new Behavior[]{new AttributeAppender("class", (IModel)Model.of((Serializable)((Object)"green")), " ")});
            } else {
                label.add(new Behavior[]{new AttributeAppender("class", (IModel)Model.of((Serializable)((Object)"red")), " ")});
            }
            this.add(new Component[]{label});
            this.add(new Component[]{new Label("runs", String.valueOf(runs))});
            this.add(new Component[]{new Label("failures", String.valueOf(failures))});
            this.add(new Component[]{new ListView<Pair<Long, String>>("blocks", this.getTestStatuses(row)){
                private static final long serialVersionUID = 1L;

                protected void populateItem(ListItem<Pair<Long, String>> item) {
                    Pair pair = (Pair)item.getModelObject();
                    item.add(new Component[]{new BuildWithInfoPanel("build", BuildUtils.getBuildFragment((Long)pair.getFirst()))});
                    String status = (String)pair.getSecond();
                    Label label = new Label("status", status);
                    item.add(new Behavior[]{new AttributeAppender("class", (IModel)Model.of((Serializable)((Object)status.toLowerCase())), " ")});
                    item.add(new Component[]{label});
                }
            }});
        }
    }

    private List<Pair<Long, String>> getTestStatuses(DataRow row) {
        List latestBuilds = (List)row.getValue("latestBuilds");
        List statuses = (List)row.getValue("latestStatuses");
        Collections.reverse(latestBuilds);
        Collections.reverse(statuses);
        int size = Math.min(latestBuilds.size(), statuses.size());
        size = Math.max(0, Math.min(size, 50));
        ArrayList result = Lists.newArrayList();
        for (int i = 0; i < size; ++i) {
            Pair pair = new Pair();
            pair.setFirst(latestBuilds.get(i));
            pair.setSecond(statuses.get(i));
            result.add(pair);
        }
        return result;
    }

    @Override
    public File getDbDir() {
        return this.getRenderer().getCategory().getReportDirOfStats(this.getConfiguration(), this.getReportSet());
    }
}

