/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.renderer.unprocessed;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.plugin.report.engine.ReportHelper;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.renderer.AbstractRenderer;
import com.pmease.quickbuild.plugin.report.engine.renderer.AbstractReportPanel;
import com.pmease.quickbuild.plugin.report.engine.renderer.RendererContext;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.wicket.Component;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.AbstractLink;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;

public class UnProcessedReportPanel
extends AbstractReportPanel {
    private static final long serialVersionUID = 1L;

    public UnProcessedReportPanel(String id, AbstractRenderer renderer, IModel<RendererContext> model) {
        super(id, renderer, model);
        this.add(new Component[]{new AbstractLink("logLink"){
            private static final long serialVersionUID = 1L;

            protected void onComponentTag(ComponentTag tag) {
                super.onComponentTag(tag);
                tag.put("href", (CharSequence)("/build/" + Context.getBuild().getId() + "/log"));
            }
        }});
        this.add(new Component[]{new ListView<DataRow>("files", (IModel)new AbstractReadOnlyModel<List<DataRow>>(){
            private static final long serialVersionUID = 1L;

            public List<DataRow> getObject() {
                return UnProcessedReportPanel.this.getDefaultReport().getRows();
            }
        }){
            private static final long serialVersionUID = 1L;

            protected void populateItem(ListItem<DataRow> item) {
                boolean toolong;
                DataRow row = (DataRow)item.getModelObject();
                item.add(new Component[]{new Label("fileName", row.getValueAsString("FILE_NAME"))});
                String content = row.getValueAsString("CONTENT");
                Object[] list = (String[])Iterables.toArray((Iterable)Splitter.on((char)'\n').split((CharSequence)content), String.class);
                boolean bl = toolong = list.length > 1000;
                if (toolong) {
                    list = (String[])ArrayUtils.subarray((Object[])list, (int)0, (int)1000);
                    content = Joiner.on((char)'\n').join(list);
                }
                content = ReportHelper.renderSource(content, "xml");
                item.add(new Component[]{new WebMarkupContainer("toolong").setVisible(toolong)});
                item.add(new Component[]{new Label("content", content).setEscapeModelStrings(false)});
                String reason = row.getValueAsString("REASON");
                item.add(new Component[]{new Label("failedReason", reason).setVisible(!StringUtils.isBlank((String)reason))});
            }
        }});
    }
}

