/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.renderer.unprocessed;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.plugin.report.engine.datastore.ReportDataSource;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.renderer.AbstractRenderer;
import com.pmease.quickbuild.plugin.report.engine.renderer.RendererContext;
import com.pmease.quickbuild.plugin.report.engine.renderer.RendererMode;
import com.pmease.quickbuild.plugin.report.engine.renderer.unprocessed.UnProcessedReportPanel;
import java.io.File;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;

public class UnProcessedRenderer
extends AbstractRenderer {
    private static final long serialVersionUID = 1L;

    public UnProcessedRenderer(ReportCategory category) {
        super(category);
        this.setOrder(50);
        this.setMode(RendererMode.BUILD);
        this.setId("renderUnProcessed");
        this.setTitle("UnProcessed Reports");
        this.setTabName("UnProcessed Reports");
        ReportDataSource dataSource = new ReportDataSource(category);
        dataSource.setFrom("unprocessed");
        this.setDataSource(dataSource);
    }

    @Override
    public String getType() {
        return "UNPROCESSED";
    }

    @Override
    public boolean isApplicable() {
        Build build = Context.getBuild();
        if (build == null) {
            return false;
        }
        String[] reportsets = this.category.getReportSetsOfBuild(build);
        if (reportsets.length == 0) {
            return false;
        }
        for (String each : reportsets) {
            File dbDir = this.category.getReportDirOfBuild(build, each);
            if (this.category.getRowsCount(dbDir, "unprocessed") <= 0L) continue;
            return true;
        }
        return false;
    }

    @Override
    public Panel createReportPanel(String id, IModel<RendererContext> model) {
        return new UnProcessedReportPanel(id, this, model);
    }
}

