/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.renderer.table.toolbar.finder;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataColumn;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.Connective;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.Func;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.Funcs;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.IncExc;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.SearchCriterion;
import com.pmease.quickbuild.plugin.report.engine.datatype.AbstractCollectionType;
import com.pmease.quickbuild.plugin.report.engine.datatype.DataTypes;
import com.pmease.quickbuild.plugin.report.engine.datatype.EnumType;
import com.pmease.quickbuild.plugin.report.engine.extensionpoint.DataType;
import com.pmease.quickbuild.plugin.report.engine.renderer.table.toolbar.finder.AdvancedSearchPanel;
import com.pmease.quickbuild.web.component.editor.EditorHelper;
import java.util.List;
import java.util.Locale;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.ajax.markup.html.form.AjaxSubmitLink;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.util.convert.IConverter;

public class CriterionEditor
extends Panel {
    private static final long serialVersionUID = 1L;
    final SearchCriterion condition;
    final AdvancedSearchPanel parentPanel;
    final int index;

    public CriterionEditor(String id, SearchCriterion condition, int index, AdvancedSearchPanel parentPanel) {
        super(id);
        Preconditions.checkArgument((condition != null ? 1 : 0) != 0);
        this.condition = condition;
        this.parentPanel = parentPanel;
        this.index = index;
    }

    protected void onInitialize() {
        super.onInitialize();
        this.setOutputMarkupId(true);
        DropDownChoice complementChoice = new DropDownChoice("complementChoice", (IModel)new PropertyModel((Object)this.condition, "include"), (List)Lists.newArrayList((Object[])IncExc.values()));
        complementChoice.add(new Behavior[]{new UpdateBeanBehavior()});
        this.add(new Component[]{complementChoice});
        DropDownChoice columnChoice = new DropDownChoice("columnChoice", (IModel)new PropertyModel((Object)this.condition, "displayName"), this.parentPanel.getAvailableColumnNames());
        columnChoice.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){
            private static final long serialVersionUID = 1L;

            protected void onUpdate(AjaxRequestTarget target) {
                DataColumn column = CriterionEditor.this.parentPanel.getColumnByDisplayName(CriterionEditor.this.condition.getDisplayName());
                if (column.getDataType() instanceof EnumType) {
                    CriterionEditor.this.condition.setOp(Funcs.EnumFunc.EQUAL);
                } else if (column.getDataType().isNumericType()) {
                    CriterionEditor.this.condition.setOp(Funcs.NumberFunc.GREATER_THAN);
                } else {
                    CriterionEditor.this.condition.setOp(Funcs.StringFunc.CONTAINING);
                }
                CriterionEditor.this.addOrReplace(new Component[]{CriterionEditor.this.createValueComponent("value", CriterionEditor.this.condition)});
                target.add(new Component[]{CriterionEditor.this});
            }
        }});
        this.add(new Component[]{columnChoice});
        DropDownChoice expChoice = new DropDownChoice("expChoice", (IModel)new PropertyModel((Object)this.condition, "op"), (IModel)new AbstractReadOnlyModel<List<? extends Func>>(){
            private static final long serialVersionUID = 1L;

            public List<? extends Func> getObject() {
                String name = CriterionEditor.this.condition.getDisplayName();
                if (Strings.isNullOrEmpty((String)name)) {
                    return Lists.newArrayList();
                }
                DataColumn column = CriterionEditor.this.parentPanel.getColumnByDisplayName(name);
                DataType dt = column.getDataType();
                if (dt.isCollectionType()) {
                    return Lists.newArrayList((Object[])new Funcs.StringFunc[]{Funcs.StringFunc.CONTAINING});
                }
                if (dt instanceof EnumType) {
                    return Lists.newArrayList((Object[])Funcs.EnumFunc.values());
                }
                if (dt.isNumericType()) {
                    return Lists.newArrayList((Object[])Funcs.NumberFunc.values());
                }
                return Lists.newArrayList((Object[])Funcs.StringFunc.values());
            }
        }, (IChoiceRenderer)new IChoiceRenderer<Func>(){

            public Object getDisplayValue(Func object) {
                return object.getDisplayName();
            }

            public String getIdValue(Func object, int index) {
                return object.toString();
            }
        });
        expChoice.add(new Behavior[]{new UpdateBeanBehavior()});
        this.add(new Component[]{expChoice});
        DropDownChoice logicChoice = new DropDownChoice("logicChoice", (IModel)new PropertyModel((Object)this.condition, "Connective"), (List)Lists.newArrayList((Object[])Connective.values()));
        logicChoice.add(new Behavior[]{new UpdateBeanBehavior()});
        this.add(new Component[]{logicChoice});
        this.add(new Component[]{this.createValueComponent("value", this.condition)});
        this.add(new Component[]{new AjaxSubmitLink("removeFilter"){
            private static final long serialVersionUID = 1L;

            protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                EditorHelper.updateFormModels(form);
                CriterionEditor.this.parentPanel.onRemove(target, CriterionEditor.this.index);
            }

            protected void onError(AjaxRequestTarget target, Form<?> form) {
            }
        }.setDefaultFormProcessing(false)});
    }

    Component createValueComponent(String id, SearchCriterion condition) {
        String name = condition.getDisplayName();
        if (condition == null || Strings.isNullOrEmpty((String)name)) {
            return new TextFrag(id, condition);
        }
        DataColumn column = this.parentPanel.getColumnByDisplayName(name);
        if (column.getDataType() instanceof EnumType) {
            return new EnumFrag(id, condition);
        }
        return new TextFrag(id, condition);
    }

    public SearchCriterion getCondition() {
        return this.condition;
    }

    class UpdateBeanBehavior
    extends AjaxFormComponentUpdatingBehavior {
        private static final long serialVersionUID = 1L;

        public UpdateBeanBehavior() {
            super("onchange");
        }

        public UpdateBeanBehavior(String event) {
            super(event);
        }

        protected void onUpdate(AjaxRequestTarget target) {
        }
    }

    class EnumFrag
    extends Fragment {
        public EnumFrag(String id, final SearchCriterion condition) {
            super(id, "enumType", (MarkupContainer)CriterionEditor.this);
            this.setOutputMarkupId(true);
            DropDownChoice<Object> choice = new DropDownChoice<Object>("value", (IModel)new PropertyModel((Object)condition, "value"), (IModel)new AbstractReadOnlyModel<List<String>>(){

                public List<String> getObject() {
                    String name = condition.getDisplayName();
                    DataColumn column = CriterionEditor.this.parentPanel.getColumnByDisplayName(name);
                    EnumType type = (EnumType)column.getDataType();
                    return Lists.newArrayList((Object[])type.getValues());
                }
            }){

                public <C> IConverter<C> getConverter(Class<C> type) {
                    String name = condition.getDisplayName();
                    DataColumn column = CriterionEditor.this.parentPanel.getColumnByDisplayName(name);
                    return new ObjectConverter(column.getDataType());
                }
            };
            choice.add(new Behavior[]{new UpdateBeanBehavior()});
            this.add(new Component[]{choice});
        }
    }

    class TextFrag
    extends Fragment {
        public TextFrag(String id, final SearchCriterion condition) {
            super(id, "textType", (MarkupContainer)CriterionEditor.this);
            this.setOutputMarkupId(true);
            this.add(new Component[]{new TextField<Object>("value", (IModel)new PropertyModel((Object)condition, "value")){

                public <C> IConverter<C> getConverter(Class<C> type) {
                    String name = condition.getDisplayName();
                    if (Strings.isNullOrEmpty((String)name)) {
                        return new ObjectConverter(DataTypes.STRING);
                    }
                    DataColumn column = CriterionEditor.this.parentPanel.getColumnByDisplayName(name);
                    return new ObjectConverter(column.getDataType());
                }
            }});
        }
    }

    class ObjectConverter
    implements IConverter<Object> {
        final DataType dataType;

        public ObjectConverter(DataType dataType) {
            this.dataType = dataType;
        }

        public Object convertToObject(String value, Locale locale) {
            if (this.dataType instanceof AbstractCollectionType) {
                return value;
            }
            return this.dataType.fromString(value, null, locale);
        }

        public String convertToString(Object value, Locale locale) {
            if (this.dataType instanceof AbstractCollectionType) {
                return (String)value;
            }
            return this.dataType.asString(value, null, locale);
        }
    }
}

