/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.renderer.table.toolbar.finder;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataColumn;
import com.pmease.quickbuild.plugin.report.engine.datareport.ReportMetaData;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.CompositeFilter;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.SearchCriterion;
import com.pmease.quickbuild.plugin.report.engine.renderer.SessionData;
import com.pmease.quickbuild.plugin.report.engine.renderer.table.datagrid.DataGrid;
import com.pmease.quickbuild.plugin.report.engine.renderer.table.toolbar.finder.CriterionEditor;
import com.pmease.quickbuild.plugin.report.engine.web.event.AdvancedFilterChanged;
import com.pmease.quickbuild.web.component.dialog.Dialog;
import com.pmease.quickbuild.web.component.editor.EditorHelper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.extensions.ajax.markup.html.IndicatingAjaxButton;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;

public class AdvancedSearchPanel
extends Panel {
    private static final long serialVersionUID = 1L;
    private final DataGrid dataGrid;
    private List<SearchCriterion> conditions = Lists.newArrayList();
    private Set<Integer> errors = Sets.newHashSet();

    public AdvancedSearchPanel(String id, DataGrid dataGrid) {
        super(id);
        this.dataGrid = dataGrid;
        CompositeFilter f = SessionData.get().getFilter().getAdvancedFilter();
        if (f != null) {
            this.conditions.addAll(f.getCriterions());
        } else {
            this.conditions.add(new SearchCriterion());
        }
    }

    private Set<Integer> validateFilters() {
        this.errors = Sets.newHashSet();
        for (int i = 0; i < this.conditions.size(); ++i) {
            SearchCriterion crit = this.conditions.get(i);
            if (Strings.isNullOrEmpty((String)crit.getDisplayName())) {
                this.errors.add(i);
            } else {
                crit.setColumnName(this.getColumnByDisplayName(crit.getDisplayName()).getColumnName());
            }
            if (this.conditions.get(i).isValid()) continue;
            this.errors.add(i);
        }
        return this.errors;
    }

    private CompositeFilter getAdvancedFilter() {
        if (this.conditions == null || this.conditions.isEmpty()) {
            return null;
        }
        boolean valid = false;
        for (SearchCriterion each : this.conditions) {
            if (!each.isValid()) continue;
            valid = true;
            DataColumn c = this.getColumnByDisplayName(each.getDisplayName());
            each.setColumnName(c.getColumnName());
        }
        if (valid) {
            return new CompositeFilter(this.conditions);
        }
        return null;
    }

    protected void onInitialize() {
        super.onInitialize();
        this.setOutputMarkupId(true);
        Form form = new Form("advancedForm", (IModel)new PropertyModel((Object)this, "conditions"));
        form.setOutputMarkupId(true);
        this.add(new Component[]{form});
        form.add(new Component[]{new IndicatingAjaxButton("applyBtn"){

            protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                AdvancedSearchPanel.this.validateFilters();
                if (AdvancedSearchPanel.this.errors.size() > 0) {
                    target.add(new Component[]{form});
                    return;
                }
                this.send((IEventSink)AdvancedSearchPanel.this.dataGrid, Broadcast.EXACT, new AdvancedFilterChanged(target, AdvancedSearchPanel.this.getAdvancedFilter()));
                Dialog.closeTopmost((AjaxRequestTarget)target);
            }

            protected void onError(AjaxRequestTarget target, Form<?> form) {
                target.add(new Component[]{form});
            }
        }});
        form.add(new Component[]{new WebMarkupContainer("errorFeedback"){

            protected void onConfigure() {
                super.onConfigure();
                this.setVisibilityAllowed(!AdvancedSearchPanel.this.errors.isEmpty());
            }
        }});
        form.add(new Component[]{new AjaxLink<Void>("cancelLink"){

            public void onClick(AjaxRequestTarget target) {
                Dialog.closeTopmost((AjaxRequestTarget)target);
            }
        }});
        FilterListView fl = new FilterListView("conditions");
        form.add(new Component[]{fl.setRenderBodyOnly(true)});
        form.add(new Component[]{new AjaxButton("addFilter", form){

            protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                EditorHelper.updateFormModels(form);
                AdvancedSearchPanel.this.errors.clear();
                AdvancedSearchPanel.this.onAdd(target);
            }

            protected void onError(AjaxRequestTarget target, Form<?> form) {
            }
        }.setDefaultFormProcessing(false)});
    }

    void onRemove(AjaxRequestTarget target, int index) {
        this.conditions.remove(index);
        this.errors.remove(index);
        if (this.conditions.isEmpty()) {
            this.conditions.add(new SearchCriterion());
        }
        target.add(new Component[]{this});
    }

    void onAdd(AjaxRequestTarget target) {
        Form form = (Form)this.get("advancedForm");
        this.conditions.add(new SearchCriterion());
        target.add(new Component[]{form});
    }

    List<String> getAvailableColumnNames() {
        ReportMetaData meta = this.dataGrid.getRenderer().getMeta();
        if (meta == null) {
            return Lists.newArrayList();
        }
        List<DataColumn> columns = meta.getSearchableColumns();
        ArrayList result = Lists.newArrayList();
        for (DataColumn each : columns) {
            result.add(each.getDisplayName());
        }
        return result;
    }

    DataColumn getColumnByDisplayName(String displayName) {
        ReportMetaData meta = this.dataGrid.getRenderer().getMeta();
        Preconditions.checkArgument((meta != null ? 1 : 0) != 0);
        return meta.getColumnByDisplayName(displayName);
    }

    String getDisplayNameOfColumn(String columnName) {
        ReportMetaData meta = this.dataGrid.getRenderer().getMeta();
        Preconditions.checkArgument((meta != null ? 1 : 0) != 0);
        DataColumn c = meta.getColumn(columnName);
        return c.getDisplayName();
    }

    class FilterListView
    extends ListView<SearchCriterion> {
        private static final long serialVersionUID = 1L;

        public FilterListView(String id) {
            super(id, AdvancedSearchPanel.this.conditions);
        }

        protected void populateItem(ListItem<SearchCriterion> item) {
            SearchCriterion condition = (SearchCriterion)item.getModelObject();
            item.setRenderBodyOnly(true);
            CriterionEditor c = new CriterionEditor("fieldFrag", condition, item.getIndex(), AdvancedSearchPanel.this);
            int index = item.getIndex();
            if (AdvancedSearchPanel.this.errors.contains(index)) {
                c.add(new Behavior[]{new AttributeAppender("class", (IModel)Model.of((Serializable)((Object)"has-error")), " ")});
            }
            item.add(new Component[]{c});
        }
    }
}

