/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.renderer.table.toolbar;

import com.google.common.base.Strings;
import com.pmease.quickbuild.plugin.report.engine.renderer.table.datagrid.DataGrid;
import com.pmease.quickbuild.util.VelocityUtils;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractToolbar;
import org.apache.wicket.extensions.markup.html.repeater.data.table.DataTable;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class VelocityToolbar
extends AbstractToolbar {
    private static final long serialVersionUID = 1L;
    final String template;

    public VelocityToolbar(DataGrid table, String extraCss, String template) {
        super((DataTable)table);
        this.template = template;
        this.setOutputMarkupId(true);
        WebMarkupContainer span = new WebMarkupContainer("span");
        this.add(new Component[]{span});
        span.add(new Behavior[]{new AttributeModifier("colspan", (IModel)Model.of((Serializable)Integer.valueOf(table.getColumns().size())))});
        if (!Strings.isNullOrEmpty((String)extraCss)) {
            span.add(new Behavior[]{new AttributeAppender("class", (IModel)Model.of((Serializable)((Object)extraCss)), " ")});
        }
        span.add(new Component[]{new Label("velocityPanel", (IModel)new AbstractReadOnlyModel<String>(){
            private static final long serialVersionUID = 1L;

            public String getObject() {
                Map<String, Object> map = VelocityToolbar.this.buildContext();
                String str = VelocityUtils.evalTemplate((String)VelocityToolbar.this.getTemplate(), map);
                return str;
            }
        }).setOutputMarkupId(true).setEscapeModelStrings(false)});
    }

    protected Map<String, Object> buildContext() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.putAll(VelocityUtils.TOOLS);
        map.put("grid", this.getTable());
        map.put("gridId", this.getTable().getMarkupId());
        return map;
    }

    protected void onConfigure() {
        super.onConfigure();
        this.setVisibilityAllowed(this.getTable().getRowCount() > 0);
    }

    public String getTemplate() {
        return this.template;
    }
}

