/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.renderer.table.toolbar;

import com.google.common.base.Strings;
import com.pmease.quickbuild.plugin.report.engine.annotation.Alias;
import com.pmease.quickbuild.plugin.report.engine.metadata.AbstractCategoryItem;
import com.pmease.quickbuild.plugin.report.engine.renderer.table.TableRenderer;
import com.pmease.quickbuild.plugin.report.engine.renderer.table.datagrid.DataGrid;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractToolbar;

public abstract class ToolbarCreator
extends AbstractCategoryItem {
    private static final long serialVersionUID = 1L;
    @Alias
    private ToolbarPosition position = ToolbarPosition.TOP;
    @Alias
    private String css;
    protected final TableRenderer renderer;

    protected abstract AbstractToolbar doCreate(DataGrid var1, String var2);

    public ToolbarCreator(TableRenderer renderer) {
        super(renderer.getCategory());
        this.renderer = renderer;
    }

    public AbstractToolbar create(DataGrid dataGrid) {
        String css = this.position == ToolbarPosition.TOP ? "top-toolbar" : "bottom-toolbar";
        if (!Strings.isNullOrEmpty((String)this.css)) {
            css = css + " " + this.css;
        }
        AbstractToolbar toolbar = this.doCreate(dataGrid, css);
        switch (this.position) {
            case TOP: {
                dataGrid.addTopToolbar(toolbar);
                break;
            }
            case BOTTOM: {
                dataGrid.addBottomToolbar(toolbar);
            }
        }
        return toolbar;
    }

    @Override
    public String getElementName() {
        return "toolbar";
    }

    public ToolbarPosition getPosition() {
        return this.position;
    }

    public void setPosition(ToolbarPosition position) {
        this.position = position;
    }

    public String getCss() {
        return this.css;
    }

    public void setCss(String css) {
        this.css = css;
    }

    public TableRenderer getRenderer() {
        return this.renderer;
    }

    public static enum ToolbarPosition {
        TOP,
        BOTTOM;

    }
}

