/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.renderer.table.toolbar;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.pmease.quickbuild.plugin.report.engine.datareport.ReportMetaData;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.ContainsFilter;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.ReportFilter;
import com.pmease.quickbuild.plugin.report.engine.renderer.SessionData;
import com.pmease.quickbuild.plugin.report.engine.renderer.table.TableRenderer;
import com.pmease.quickbuild.plugin.report.engine.renderer.table.datagrid.DataGrid;
import com.pmease.quickbuild.plugin.report.engine.renderer.table.event.DataGridPageChanged;
import com.pmease.quickbuild.plugin.report.engine.renderer.table.event.DropDownPageChanged;
import com.pmease.quickbuild.plugin.report.engine.renderer.table.toolbar.NavigationLabel;
import com.pmease.quickbuild.plugin.report.engine.renderer.table.toolbar.SearchNavToolbarCreator;
import com.pmease.quickbuild.plugin.report.engine.renderer.table.toolbar.finder.AdvancedSearchPanel;
import com.pmease.quickbuild.plugin.report.engine.web.event.AdvancedFilterChanged;
import com.pmease.quickbuild.plugin.report.engine.web.event.AjaxEvent;
import com.pmease.quickbuild.plugin.report.engine.web.event.ReportFilterChanged;
import com.pmease.quickbuild.web.component.dialog.Dialog;
import java.io.Serializable;
import java.util.List;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.IAjaxIndicatorAware;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.extensions.ajax.markup.html.IndicatingAjaxButton;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractToolbar;
import org.apache.wicket.extensions.markup.html.repeater.data.table.DataTable;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IFormSubmittingComponent;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;

public class SearchNavToolbar
extends AbstractToolbar
implements IAjaxIndicatorAware {
    private static final long serialVersionUID = 1L;
    private String pattern;
    private Integer pageNum = 1;
    protected String extraCss;
    private final SearchNavToolbarCreator creator;
    private static final List<Integer> ROWS_PER_PAGE = ImmutableList.of((Object)5, (Object)10, (Object)20, (Object)50, (Object)100, (Object)200, (Object)500);

    public SearchNavToolbar(DataGrid dataGrid, String extraCss) {
        this(dataGrid, extraCss, null);
    }

    public SearchNavToolbar(DataGrid dataGrid, String extraCss, SearchNavToolbarCreator creator) {
        super((DataTable)dataGrid);
        this.extraCss = extraCss;
        this.creator = creator;
        this.setOutputMarkupId(true);
    }

    public void onInitialize() {
        super.onInitialize();
        WebMarkupContainer span = new WebMarkupContainer("span");
        this.add(new Component[]{span});
        span.add(new Behavior[]{new AttributeModifier("colspan", (IModel)Model.of((Serializable)Integer.valueOf(this.getTable().getColumns().size())))});
        if (!Strings.isNullOrEmpty((String)this.extraCss)) {
            span.add(new Behavior[]{new AttributeAppender("class", (IModel)Model.of((Serializable)((Object)this.extraCss)), " ")});
        }
        this.updateParams();
        FilterForm filterForm = new FilterForm("simpleSearchForm");
        span.add(new Component[]{filterForm});
        AjaxLink<Void> advancedLink = new AjaxLink<Void>("advancedLink"){
            private static final long serialVersionUID = 1L;

            public void onClick(AjaxRequestTarget target) {
                Dialog dialog = new Dialog("Advanced Search"){
                    private static final long serialVersionUID = 1L;

                    protected Component render(String componentId) {
                        return new AdvancedSearchPanel(componentId, SearchNavToolbar.this.getTable());
                    }
                };
                dialog.dialogClass("search-dlg").width(600).open(target);
            }
        };
        ReportMetaData meta = this.getTable().getRenderer().getMeta();
        advancedLink.setVisibilityAllowed(meta != null && !meta.getSearchableColumns().isEmpty());
        filterForm.add(new Component[]{advancedLink});
        NavigationForm navigationForm = new NavigationForm("navigationForm");
        span.add(new Component[]{navigationForm});
    }

    protected boolean isShowSearchForm() {
        if (this.creator == null) {
            return true;
        }
        return this.creator.isShowSearchForm();
    }

    protected boolean isShowNavForm() {
        if (this.creator == null) {
            return true;
        }
        return this.creator.isShowNavForm();
    }

    private void updateParams() {
        this.pageNum = this.getTable().getCurrentPage() + 1;
        ReportFilter reportFilter = SessionData.get().getFilter();
        ContainsFilter containsFilter = null;
        if (reportFilter != null && reportFilter.hasContainsFilter()) {
            containsFilter = reportFilter.getContainsFilter();
        }
        this.pattern = containsFilter != null ? containsFilter.getPattern() : null;
    }

    public void onConfigure() {
        super.onConfigure();
        DataGrid dataGrid = this.getTable();
        if (dataGrid.getRenderer().isInDropDown()) {
            this.setVisibilityAllowed(dataGrid.getRowCount() > dataGrid.getRenderer().getRowsPerPage());
        }
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public Integer getPageNum() {
        return this.pageNum;
    }

    public void setPageNum(Integer pageNum) {
        this.pageNum = pageNum;
    }

    protected void broadcastPageChangedEvent(AjaxRequestTarget target) {
        TableRenderer renderer = this.getTable().getRenderer();
        if (renderer.isInDropDown()) {
            this.send((IEventSink)this.getTable(), Broadcast.BREADTH, new DropDownPageChanged(target, this.pageNum));
        } else {
            this.send((IEventSink)this.getTable(), Broadcast.BREADTH, new DataGridPageChanged(target, this.pageNum));
        }
    }

    public void onEvent(IEvent<?> sink) {
        if (sink.getPayload() instanceof AjaxEvent) {
            this.updateParams();
            ((AjaxEvent)sink.getPayload()).getTarget().add(new Component[]{this});
        }
    }

    public void onEvent(ReportFilterChanged event) {
        this.updateParams();
        event.getTarget().add(new Component[]{this});
    }

    public void onEvent(DataGridPageChanged event) {
        this.updateParams();
        event.getTarget().add(new Component[]{this});
    }

    public void onEvent(AdvancedFilterChanged event) {
        this.updateParams();
        event.getTarget().add(new Component[]{this});
    }

    public String getAjaxIndicatorMarkupId() {
        return "global-ajax-indicator";
    }

    public DataGrid getTable() {
        return (DataGrid)super.getTable();
    }

    public static class NavBar
    extends SearchNavToolbar {
        private static final long serialVersionUID = 1L;
        private final int rows;

        public NavBar(DataGrid dataGrid, int rows) {
            super(dataGrid, null, null);
            this.rows = rows;
        }

        @Override
        public void onConfigure() {
            super.onConfigure();
            this.setVisible(this.getTable().getRowCount() > this.rows);
        }

        @Override
        protected boolean isShowSearchForm() {
            return false;
        }

        @Override
        protected boolean isShowNavForm() {
            return true;
        }
    }

    private class NavigationForm
    extends Form<Void> {
        private static final long serialVersionUID = 1L;

        public NavigationForm(String id) {
            super(id);
            this.add(new Component[]{new TextField("currentPage", (IModel)new PropertyModel((Object)SearchNavToolbar.this, "pageNum"))});
            IndicatingAjaxButton submitButton = new IndicatingAjaxButton("submit"){
                private static final long serialVersionUID = 1L;

                protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                    int totals = SearchNavToolbar.this.getTable().getPageCount();
                    SearchNavToolbar.this.pageNum = Math.min(SearchNavToolbar.this.pageNum, totals);
                    SearchNavToolbar.this.pageNum = Math.max(SearchNavToolbar.this.pageNum, 1);
                    SearchNavToolbar.this.broadcastPageChangedEvent(target);
                }

                protected void onError(AjaxRequestTarget target, Form<?> form) {
                    target.add(new Component[]{form});
                }
            };
            this.add(new Component[]{submitButton});
            this.setDefaultButton((IFormSubmittingComponent)submitButton);
            DropDownChoice rowsChoice = new DropDownChoice("rowsPerPage", (IModel)new PropertyModel((Object)SearchNavToolbar.this.getTable(), "itemsPerPage"), ROWS_PER_PAGE);
            rowsChoice.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){
                private static final long serialVersionUID = 1L;

                protected void onUpdate(AjaxRequestTarget target) {
                    if (target != null) {
                        SearchNavToolbar.this.pageNum = 1;
                        SearchNavToolbar.this.broadcastPageChangedEvent(target);
                    }
                }
            }});
            this.add(new Component[]{rowsChoice});
            this.add(new Component[]{new AjaxButton("previous", this){
                private static final long serialVersionUID = 1L;

                protected void onError(AjaxRequestTarget target, Form<?> form) {
                    target.add(new Component[]{form});
                }

                protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                    int currentPage = SearchNavToolbar.this.getTable().getCurrentPage() + 1;
                    if (currentPage == 1) {
                        return;
                    }
                    int totals = SearchNavToolbar.this.getTable().getPageCount();
                    SearchNavToolbar.this.pageNum = Math.min(--currentPage, totals);
                    SearchNavToolbar.this.pageNum = Math.max(SearchNavToolbar.this.pageNum, 1);
                    SearchNavToolbar.this.broadcastPageChangedEvent(target);
                }
            }});
            this.add(new Component[]{new AjaxButton("next", this){
                private static final long serialVersionUID = 1L;

                protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                    int totals;
                    int currentPage = SearchNavToolbar.this.getTable().getCurrentPage() + 1;
                    if (currentPage == (totals = SearchNavToolbar.this.getTable().getPageCount())) {
                        return;
                    }
                    SearchNavToolbar.this.pageNum = Math.min(++currentPage, totals);
                    SearchNavToolbar.this.pageNum = Math.max(SearchNavToolbar.this.pageNum, 1);
                    SearchNavToolbar.this.broadcastPageChangedEvent(target);
                }

                protected void onError(AjaxRequestTarget target, Form<?> form) {
                    target.add(new Component[]{form});
                }
            }});
            this.add(new Component[]{new NavigationLabel("pageInfo", SearchNavToolbar.this.getTable())});
        }

        protected void onConfigure() {
            super.onConfigure();
            this.setVisibilityAllowed(SearchNavToolbar.this.isShowNavForm());
        }
    }

    private class FilterForm
    extends Form<Void> {
        private static final long serialVersionUID = 1L;

        public FilterForm(String id) {
            super(id);
            this.setOutputMarkupId(true);
        }

        public void onInitialize() {
            super.onInitialize();
            IndicatingAjaxButton filterSubmit = new IndicatingAjaxButton("filterSubmit", this){
                private static final long serialVersionUID = 1L;

                protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                    ReportFilter oldFilter = SessionData.get().getFilter();
                    ReportFilter newFilter = oldFilter == null ? new ReportFilter() : new ReportFilter(oldFilter);
                    DataGrid dataGrid = SearchNavToolbar.this.getTable();
                    if (Strings.isNullOrEmpty((String)SearchNavToolbar.this.pattern)) {
                        newFilter.setContainsFilter(null);
                    } else {
                        ContainsFilter containsFilter = new ContainsFilter(dataGrid.getRenderer().getContainsColumns(), SearchNavToolbar.this.pattern);
                        newFilter.setContainsFilter(containsFilter);
                    }
                    if (Objects.equal((Object)newFilter, (Object)oldFilter)) {
                        return;
                    }
                    this.send((IEventSink)SearchNavToolbar.this.getTable(), Broadcast.BREADTH, new ReportFilterChanged(target, newFilter));
                }

                protected void onError(AjaxRequestTarget target, Form<?> form) {
                    target.add(new Component[]{form});
                }
            };
            this.add(new Component[]{filterSubmit});
            this.setDefaultButton((IFormSubmittingComponent)filterSubmit);
            TextField patternField = new TextField("pattern", (IModel)new PropertyModel((Object)SearchNavToolbar.this, "pattern"));
            this.add(new Component[]{patternField});
        }

        protected void onConfigure() {
            super.onConfigure();
            this.setVisibilityAllowed(SearchNavToolbar.this.isShowSearchForm());
        }
    }
}

