/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.renderer.table.toolbar;

import com.google.common.collect.Lists;
import com.pmease.quickbuild.plugin.report.engine.renderer.table.TableRenderer;
import com.pmease.quickbuild.plugin.report.engine.renderer.table.datagrid.DataGrid;
import com.pmease.quickbuild.plugin.report.engine.renderer.table.toolbar.ScorecardColumn;
import com.pmease.quickbuild.plugin.report.engine.renderer.table.toolbar.ScorecardToolbar;
import com.pmease.quickbuild.plugin.report.engine.renderer.table.toolbar.ToolbarCreator;
import com.pmease.quickbuild.plugin.report.engine.util.TypedObjects;
import java.util.List;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractToolbar;
import org.dom4j.Element;

public class ScorecardToolbarCreator
extends ToolbarCreator {
    private static final long serialVersionUID = 1L;
    List<ScorecardColumn> columns = Lists.newArrayList();

    public ScorecardToolbarCreator(TableRenderer renderer) {
        super(renderer);
    }

    @Override
    public String getType() {
        return "SCORECARDS";
    }

    @Override
    protected AbstractToolbar doCreate(DataGrid dataGrid, String extraCss) {
        return new ScorecardToolbar(dataGrid, extraCss, this.columns);
    }

    public List<ScorecardColumn> getColumns() {
        return this.columns;
    }

    public void setColumns(List<ScorecardColumn> columns) {
        this.columns = columns;
    }

    @Override
    public void fromXML(Element node) {
        super.fromXML(node);
        List nodes = node.elements("column");
        for (Element each : nodes) {
            ScorecardColumn column = TypedObjects.createTypedObject(each, ScorecardColumn.class, new ScorecardColumn(this.getRenderer()), this.getRenderer());
            column.fromXML(each);
            this.columns.add(column);
        }
    }
}

