/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.renderer.table.toolbar;

import com.google.common.base.Strings;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.datareport.ReportStats;
import com.pmease.quickbuild.plugin.report.engine.renderer.ItemContext;
import com.pmease.quickbuild.plugin.report.engine.renderer.table.datagrid.DataGrid;
import com.pmease.quickbuild.plugin.report.engine.renderer.table.provider.ReportDataProvider;
import com.pmease.quickbuild.plugin.report.engine.renderer.table.toolbar.ScorecardColumn;
import com.pmease.quickbuild.plugin.report.engine.renderer.table.toolbar.ScorecardPanel;
import java.io.Serializable;
import java.util.List;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractToolbar;
import org.apache.wicket.extensions.markup.html.repeater.data.table.DataTable;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;

public class ScorecardToolbar
extends AbstractToolbar {
    private static final long serialVersionUID = 1L;

    public ScorecardToolbar(DataGrid dataGrid, String extraCss, List<ScorecardColumn> columns) {
        super((DataTable)dataGrid);
        this.setOutputMarkupId(true);
        WebMarkupContainer span = new WebMarkupContainer("span");
        this.add(new Component[]{span});
        span.add(new Behavior[]{new AttributeModifier("colspan", (IModel)Model.of((Serializable)Integer.valueOf(dataGrid.getColumns().size())))});
        if (!Strings.isNullOrEmpty((String)extraCss)) {
            span.add(new Behavior[]{new AttributeAppender("class", (IModel)Model.of((Serializable)((Object)extraCss)), " ")});
        }
        LoadableDetachableModel<ItemContext> itemModel = new LoadableDetachableModel<ItemContext>(){
            private static final long serialVersionUID = 1L;

            protected ItemContext load() {
                DataGrid grid = (DataGrid)ScorecardToolbar.this.getTable();
                ReportDataProvider provider = grid.getProvider();
                ReportStats stats = provider.getReportStats();
                DataRow row = stats.getRow(0);
                ItemContext context = provider.createItemContext(row);
                context.setExpressionContext(stats.getStats());
                return context;
            }
        };
        span.add(new Component[]{this.createScorecardPanel("scorecards", (IModel<ItemContext>)itemModel, columns)});
    }

    protected Component createScorecardPanel(String id, IModel<ItemContext> model, List<ScorecardColumn> columns) {
        return new ScorecardPanel(id, model, columns);
    }

    public void onDetach() {
        super.onDetach();
    }
}

