/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.renderer.table.toolbar;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.pmease.quickbuild.plugin.report.engine.datareport.ReportMetaData;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.Filter;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.ReportFilter;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.SearchCriterion;
import com.pmease.quickbuild.plugin.report.engine.renderer.RendererMode;
import com.pmease.quickbuild.plugin.report.engine.renderer.SessionData;
import com.pmease.quickbuild.plugin.report.engine.renderer.table.TableRenderer;
import com.pmease.quickbuild.plugin.report.engine.renderer.table.datagrid.DataGrid;
import com.pmease.quickbuild.plugin.report.engine.util.ReportUtils;
import com.pmease.quickbuild.plugin.report.engine.web.AjaxTextLink;
import com.pmease.quickbuild.plugin.report.engine.web.TextLink;
import com.pmease.quickbuild.plugin.report.engine.web.event.ReportFilterChanged;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractToolbar;
import org.apache.wicket.extensions.markup.html.repeater.data.table.DataTable;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class BreadcrumbToolbar
extends AbstractToolbar {
    private static final long serialVersionUID = 1L;
    final DataGrid dataGrid;
    IModel<List<Filter>> filterModel;

    public BreadcrumbToolbar(final DataGrid dataGrid, final boolean sortFilter) {
        super((DataTable)dataGrid);
        this.dataGrid = dataGrid;
        this.setOutputMarkupId(true);
        WebMarkupContainer container = new WebMarkupContainer("span");
        this.add(new Component[]{container});
        container.add(new Behavior[]{new AttributeModifier("colspan", (IModel)Model.of((Serializable)Integer.valueOf(dataGrid.getColumns().size())))});
        container.add(new Component[]{new AjaxLink<Void>("allLink"){
            private static final long serialVersionUID = 1L;

            public void onClick(AjaxRequestTarget target) {
                SessionData.get().clearFilter();
                this.send((IEventSink)dataGrid, Broadcast.BREADTH, new ReportFilterChanged(target, null));
            }
        }});
        this.filterModel = new AbstractReadOnlyModel<List<Filter>>(){
            private static final long serialVersionUID = 1L;

            public List<Filter> getObject() {
                ReportFilter f = SessionData.get().getFilter();
                ReportFilter reportFilter = new ReportFilter(f);
                ReportMetaData meta = ((DataGrid)BreadcrumbToolbar.this.getTable()).getRenderer().getMeta();
                if (meta != null) {
                    Set<String> names = reportFilter.getAllColumnNames();
                    for (String each : names) {
                        int pos;
                        String column = each.substring((pos = each.indexOf(".")) + 1);
                        if (meta.hasColumn(column)) continue;
                        reportFilter.remove(column);
                    }
                }
                ArrayList list = Lists.newArrayList();
                List<SearchCriterion> simples = reportFilter.getSimpleFilters();
                if (sortFilter) {
                    Collections.sort(simples, new Comparator<SearchCriterion>(){

                        @Override
                        public int compare(SearchCriterion o1, SearchCriterion o2) {
                            String column1 = o1.getColumnName();
                            String column2 = o2.getColumnName();
                            int pos = column1.indexOf(".");
                            if (pos > 0) {
                                column1 = column1.substring(pos + 1);
                            }
                            if ((pos = column2.indexOf(".")) > 0) {
                                column2 = column2.substring(pos + 1);
                            }
                            ReportMetaData meta = dataGrid.getRenderer().getMeta();
                            int index1 = meta.getColumnIndex(column1);
                            int index2 = meta.getColumnIndex(column2);
                            return index1 - index2;
                        }
                    });
                }
                list.addAll(simples);
                if (reportFilter.hasAdvancedFilter()) {
                    list.add(reportFilter.getAdvancedFilter());
                }
                if (reportFilter.hasContainsFilter()) {
                    list.add(reportFilter.getContainsFilter());
                }
                return reportFilter.getAllFilters();
            }
        };
        container.add(new Component[]{new BreadCrumbsListView("links", this.filterModel)});
    }

    protected List<Filter> getFilters() {
        return (List)this.filterModel.getObject();
    }

    protected void onConfigure() {
        List<Filter> filters;
        super.onConfigure();
        TableRenderer renderer = this.dataGrid.getRenderer();
        RendererMode mode = renderer.getMode();
        boolean visible = true;
        visible = renderer.isInDropDown() || renderer.isIgnoreSessionFilter() ? false : (mode != RendererMode.BUILD && mode != RendererMode.STATISTICS ? false : !(filters = this.getFilters()).isEmpty());
        this.setVisibilityAllowed(visible);
    }

    public void onDetach() {
        this.filterModel.detach();
        super.onDetach();
    }

    private class BreadCrumbsListView
    extends ListView<Filter> {
        private static final long serialVersionUID = 1L;

        public BreadCrumbsListView(String id, IModel<List<Filter>> model) {
            super(id, model);
        }

        protected void populateItem(ListItem<Filter> item) {
            Filter f = (Filter)item.getModelObject();
            String full = f.toBreadcrumb();
            if (Strings.isNullOrEmpty((String)full)) {
                full = "[empty]";
            }
            int size = this.getList().size();
            final int index = item.getIndex();
            String str = ReportUtils.cropText(full, 48);
            AjaxTextLink c = index + 1 < size ? new AjaxTextLink("link", str){
                private static final long serialVersionUID = 1L;

                public void onClick(AjaxRequestTarget target) {
                    List<Filter> filters = BreadcrumbToolbar.this.getFilters();
                    ReportFilter newFilter = new ReportFilter();
                    newFilter.setFilters(Lists.newArrayList(filters.subList(0, index + 1)));
                    this.send((IEventSink)BreadcrumbToolbar.this.getTable(), Broadcast.BREADTH, new ReportFilterChanged(target, newFilter));
                }
            } : new TextLink("link", (IModel)Model.of((Serializable)((Object)str))){
                private static final long serialVersionUID = 1L;

                public void onClick() {
                }
            }.setEnabled(false);
            c.add(new Behavior[]{new AttributeModifier("title", (IModel)Model.of((Serializable)((Object)full)))});
            item.add(new Component[]{c});
        }
    }
}

