/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.renderer.table.provider;

import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.datareport.ReportStats;
import com.pmease.quickbuild.plugin.report.engine.datastore.Order;
import com.pmease.quickbuild.plugin.report.engine.datastore.ReportDataSource;
import com.pmease.quickbuild.plugin.report.engine.renderer.ItemContext;
import com.pmease.quickbuild.plugin.report.engine.renderer.table.TableReportPanel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;
import org.apache.wicket.extensions.markup.html.repeater.util.SortableDataProvider;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class ReportDataProvider
extends SortableDataProvider<ItemContext> {
    private static final long serialVersionUID = 1L;
    protected TableReportPanel reportPanel;

    public ReportDataProvider(TableReportPanel reportPanel) {
        this.reportPanel = reportPanel;
    }

    public Iterator<? extends ItemContext> iterator(int first, int count) {
        return this.reportPanel.iterator(first, count);
    }

    public ItemContext createItemContext(DataRow row) {
        return this.reportPanel.createItemContext(row);
    }

    public List<Order> getOrders() {
        SortParam sort = this.getSort();
        ArrayList orders = Lists.newArrayList();
        if (sort != null) {
            String[] tokens;
            String property = sort.getProperty();
            boolean ascending = sort.isAscending();
            for (String each : tokens = (String[])Iterables.toArray((Iterable)Splitter.on((String)",").omitEmptyStrings().split((CharSequence)property), String.class)) {
                orders.add(new Order(each, ascending));
            }
        }
        return orders;
    }

    public String getSortProperty() {
        SortParam sort = this.getSort();
        if (sort != null) {
            return sort.getProperty();
        }
        return "";
    }

    public int size() {
        if (!this.reportPanel.isShowReports()) {
            return 0;
        }
        ReportDataSource rds = this.reportPanel.getRenderer().getDataSource();
        ReportStats stats = this.getReportStats();
        DataRow row = stats.getRow(0);
        Long l = row.getLong("TOTALS");
        Long maxRows = Long.MAX_VALUE;
        if (rds != null && rds.getMaxRows() > 0) {
            maxRows = new Long(rds.getMaxRows());
        }
        Long size = Math.min(l, maxRows);
        return size.intValue();
    }

    public ReportStats getReportStats() {
        return this.reportPanel.getReportStats();
    }

    public IModel<ItemContext> model(ItemContext object) {
        return Model.of((Serializable)object);
    }
}

