/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.renderer.table.provider;

import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.pmease.quickbuild.util.ExceptionUtils;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.collections.comparators.ComparableComparator;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;
import org.apache.wicket.extensions.markup.html.repeater.util.SortableDataProvider;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class ListDataProvider<T extends Serializable>
extends SortableDataProvider<T> {
    private static final long serialVersionUID = 1L;
    private IModel<List<T>> listModel;

    public ListDataProvider(IModel<List<T>> listModel) {
        this.listModel = listModel;
    }

    public List<T> getValues() {
        return (List)this.listModel.getObject();
    }

    public Iterator<? extends T> iterator(int first, int count) {
        List<T> values = this.getValues();
        final SortParam sp = this.getSort();
        if (sp == null) {
            return values.listIterator(first);
        }
        Collections.sort(values, new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                String[] fields;
                int r;
                int n = r = sp.isAscending() ? 1 : -1;
                if (o1 == null && o2 == null) {
                    return 0;
                }
                if (o1 == null) {
                    return -1 * r;
                }
                if (o2 == null) {
                    return 1 * r;
                }
                String sortProperty = sp.getProperty();
                for (String each : fields = (String[])Iterables.toArray((Iterable)Splitter.on((char)',').trimResults().omitEmptyStrings().split((CharSequence)sortProperty), String.class)) {
                    Object value1 = ListDataProvider.getFieldValue(o1, each);
                    Object value2 = ListDataProvider.getFieldValue(o2, each);
                    int i = value1 == null && value2 == null ? 0 : (value1 == null ? -1 : (value2 == null ? 1 : ComparableComparator.getInstance().compare(value1, value2)));
                    if (i == 0) continue;
                    return i * r;
                }
                return 0;
            }
        });
        return values.listIterator(first);
    }

    static Object getFieldValue(Object obj, String field) {
        try {
            return PropertyUtils.getProperty((Object)obj, (String)field);
        }
        catch (SecurityException e) {
            throw ExceptionUtils.wrapAsUnchecked((Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw ExceptionUtils.wrapAsUnchecked((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw ExceptionUtils.wrapAsUnchecked((Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw ExceptionUtils.wrapAsUnchecked((Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw ExceptionUtils.wrapAsUnchecked((Throwable)e);
        }
    }

    public int size() {
        return this.getValues().size();
    }

    public IModel<T> model(T object) {
        return Model.of(object);
    }

    public void detach() {
        if (this.listModel != null) {
            this.listModel.detach();
        }
        super.detach();
    }
}

