/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.renderer.table.datagrid;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.pmease.quickbuild.plugin.report.engine.ReportHelper;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.renderer.ItemContext;
import com.pmease.quickbuild.plugin.report.engine.renderer.table.TableReportPanel;
import com.pmease.quickbuild.plugin.report.engine.renderer.table.datagrid.DataGrid;
import com.pmease.quickbuild.plugin.report.engine.renderer.table.provider.ReportDataProvider;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class GroupableDataGrid
extends DataGrid {
    private static final long serialVersionUID = 1L;
    protected transient DataRow previous;

    public GroupableDataGrid(String id, List<IColumn<ItemContext>> columns, ReportDataProvider dataProvider, TableReportPanel parentPanel) {
        super(id, columns, dataProvider, parentPanel);
    }

    @Override
    protected Item<ItemContext> newRowItem(String id, int index, IModel<ItemContext> rowModel) {
        Item item = new Item(id, index, rowModel);
        if (this.isGroupable()) {
            item.add(new Behavior[]{new GroupBehavior()});
        }
        item.add(new Behavior[]{new AttributeAppender("class", (IModel)Model.of((Serializable)((Object)"subrow")), " ")});
        return item;
    }

    protected boolean isGroupable() {
        return this.getRenderer().getGroupBy().length > 0;
    }

    protected boolean isGroupRow(DataRow current) {
        String[] groupBy;
        if (this.previous == null) {
            return true;
        }
        for (String each : groupBy = this.getRenderer().getGroupBy()) {
            if (Objects.equal((Object)current.getValue(each), (Object)this.previous.getValue(each))) continue;
            return true;
        }
        return false;
    }

    protected String getGroupRowHtml(DataRow current) {
        String template = this.getRenderer().getGroupRowTemplate();
        Map<String, Object> map = current.toMap();
        map.put("row", current);
        return ReportHelper.evaluateVelocity(template, map);
    }

    public void onDetach() {
        this.previous = null;
        super.onDetach();
    }

    public class GroupBehavior
    extends Behavior {
        private static final long serialVersionUID = 1L;

        public void beforeRender(Component component) {
            ItemContext context = (ItemContext)component.getDefaultModelObject();
            DataRow current = context.getDataRow();
            if (GroupableDataGrid.this.isGroupRow(current)) {
                String str = GroupableDataGrid.this.getGroupRowHtml(current);
                if (!Strings.isNullOrEmpty((String)str)) {
                    component.getResponse().write((CharSequence)str);
                }
                GroupableDataGrid.this.previous = current;
            }
        }
    }
}

