/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.renderer.table.datagrid;

import com.google.common.base.Objects;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.ReportFilter;
import com.pmease.quickbuild.plugin.report.engine.renderer.ItemContext;
import com.pmease.quickbuild.plugin.report.engine.renderer.SessionData;
import com.pmease.quickbuild.plugin.report.engine.renderer.table.TableRenderer;
import com.pmease.quickbuild.plugin.report.engine.renderer.table.TableReportPanel;
import com.pmease.quickbuild.plugin.report.engine.renderer.table.event.DataGridPageChanged;
import com.pmease.quickbuild.plugin.report.engine.renderer.table.event.DropDownPageChanged;
import com.pmease.quickbuild.plugin.report.engine.renderer.table.provider.ReportDataProvider;
import com.pmease.quickbuild.plugin.report.engine.web.event.AdvancedFilterChanged;
import com.pmease.quickbuild.plugin.report.engine.web.event.AjaxPageChangedEvent;
import com.pmease.quickbuild.plugin.report.engine.web.event.ReportFilterChanged;
import java.io.Serializable;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.extensions.markup.html.repeater.data.table.DataTable;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.markup.repeater.OddEvenItem;
import org.apache.wicket.markup.repeater.data.IDataProvider;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class DataGrid
extends DataTable<ItemContext> {
    private static final long serialVersionUID = 1L;
    protected final TableReportPanel parentPanel;
    WebMarkupContainer body;

    public DataGrid(String id, List<IColumn<ItemContext>> columns, ReportDataProvider dataProvider, TableReportPanel parentPanel) {
        super(id, columns, (IDataProvider)dataProvider, parentPanel.getRowsPerPage());
        this.parentPanel = parentPanel;
        this.setOutputMarkupId(true);
        this.setVersioned(false);
    }

    protected Item<ItemContext> newRowItem(String id, int index, IModel<ItemContext> rowModel) {
        return new OddEvenItem(id, index, rowModel);
    }

    protected Item<IColumn<ItemContext>> newCellItem(String id, int index, IModel<IColumn<ItemContext>> model) {
        Item item = super.newCellItem(id, index, model);
        String sortProperty = ((IColumn)this.getColumns().get(index)).getSortProperty();
        if (sortProperty != null && Objects.equal((Object)sortProperty, (Object)this.getProvider().getSortProperty())) {
            item.add(new Behavior[]{new AttributeAppender("class", (IModel)Model.of((Serializable)((Object)"ordered")), " ")});
        }
        if (index == 0) {
            item.add(new Behavior[]{new AttributeAppender("class", (IModel)Model.of((Serializable)((Object)"first")), " ")});
        }
        if (index == this.getColumns().size() - 1) {
            item.add(new Behavior[]{new AttributeAppender("class", (IModel)Model.of((Serializable)((Object)"last")), " ")});
        }
        return item;
    }

    protected WebMarkupContainer newBodyContainer(String id) {
        super.newBodyContainer(id);
        this.body = new WebMarkupContainer(id);
        this.body.setOutputMarkupId(true);
        return this.body;
    }

    public TableRenderer getRenderer() {
        return this.parentPanel.getRenderer();
    }

    public ReportDataProvider getProvider() {
        return (ReportDataProvider)super.getDataProvider();
    }

    public TableReportPanel getReportPanel() {
        return this.parentPanel;
    }

    public void onEvent(IEvent<?> sink) {
        Object payload = sink.getPayload();
        if (payload instanceof AdvancedFilterChanged) {
            this.onEvent((AdvancedFilterChanged)payload);
        } else if (payload instanceof ReportFilterChanged) {
            this.onEvent((ReportFilterChanged)payload);
        } else if (payload instanceof DropDownPageChanged) {
            this.onEvent((DropDownPageChanged)payload);
        } else if (payload instanceof DataGridPageChanged) {
            this.onEvent((DataGridPageChanged)payload);
        }
    }

    public void onEvent(ReportFilterChanged event) {
        SessionData.get().setFilter(event.getFilter());
        this.setCurrentPage(0);
        event.getTarget().add(new Component[]{this});
    }

    public void onEvent(AdvancedFilterChanged event) {
        ReportFilter r = SessionData.get().getFilter();
        r.setAdvancedFilter(event.getFilter());
        this.setCurrentPage(0);
        event.getTarget().add(new Component[]{this});
    }

    private void onPageChanged(AjaxPageChangedEvent event) {
        Integer page = event.getPage();
        this.setCurrentPage(page - 1);
        event.getTarget().add(new Component[]{this});
        this.parentPanel.onAjaxEvent(event);
    }

    public void onEvent(DropDownPageChanged event) {
        this.onPageChanged(event);
    }

    public void onEvent(DataGridPageChanged event) {
        this.onPageChanged(event);
    }
}

