/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.renderer.table.column;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.pmease.quickbuild.plugin.report.engine.annotation.Alias;
import com.pmease.quickbuild.plugin.report.engine.datareport.ReportMetaData;
import com.pmease.quickbuild.plugin.report.engine.datatype.EnumType;
import com.pmease.quickbuild.plugin.report.engine.datatype.StringType;
import com.pmease.quickbuild.plugin.report.engine.extensionpoint.DataType;
import com.pmease.quickbuild.plugin.report.engine.renderer.AbstractRenderer;
import com.pmease.quickbuild.plugin.report.engine.renderer.item.CompositeItem;
import com.pmease.quickbuild.plugin.report.engine.renderer.item.FilterLinkItem;
import org.dom4j.Element;

public class TableColumn
extends CompositeItem {
    private static final long serialVersionUID = 1L;
    @Alias
    private String title;
    @Alias
    private String orderBy;
    @Alias
    private String key;
    @Alias
    private boolean mergeRow = false;

    public TableColumn(AbstractRenderer renderer) {
        super(renderer);
    }

    public FilterLinkItem createFilterItem(String filterBy, String values) {
        FilterLinkItem item = new FilterLinkItem(this.getRenderer());
        item.setFilterBy(filterBy);
        item.setValueExpression(values);
        return item;
    }

    @Override
    public void fromXML(Element node) {
        super.fromXML(node);
        if (Strings.isNullOrEmpty((String)this.getCss())) {
            this.setCss(this.getDefaultCss());
        }
        if (Strings.isNullOrEmpty((String)this.key)) {
            this.key = this.getTitle();
        }
    }

    protected String getDefaultCss() {
        if (!Strings.isNullOrEmpty((String)this.orderBy)) {
            String[] orders = (String[])Iterables.toArray((Iterable)Splitter.on((char)',').trimResults().omitEmptyStrings().split((CharSequence)this.orderBy), String.class);
            ReportMetaData meta = this.renderer.getMeta();
            if (orders.length > 0 && meta != null) {
                DataType dataType = meta.getColumn(orders[0]).getDataType();
                if (dataType.isNumericType()) {
                    return "number";
                }
                if (dataType instanceof EnumType) {
                    return "enum";
                }
                if (dataType instanceof StringType) {
                    return "text";
                }
            }
        }
        return null;
    }

    @Override
    public String getType() {
        return "DEFAULT";
    }

    @Override
    public String getElementName() {
        return "column";
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getOrderBy() {
        return this.orderBy;
    }

    public void setOrderBy(String orderBy) {
        this.orderBy = orderBy;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public boolean isMergeRow() {
        return this.mergeRow;
    }

    public void setMergeRow(boolean mergeRow) {
        this.mergeRow = mergeRow;
    }
}

