/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.renderer.table.column;

import com.google.common.base.Strings;
import com.pmease.quickbuild.plugin.report.engine.renderer.AbstractRenderer;
import com.pmease.quickbuild.plugin.report.engine.renderer.ItemContext;
import com.pmease.quickbuild.plugin.report.engine.renderer.item.RendererItem;
import com.pmease.quickbuild.plugin.report.engine.renderer.table.column.TableColumn;
import com.pmease.quickbuild.plugin.report.engine.web.StackBarPanel;
import com.pmease.quickbuild.web.component.dashboardpanel.StatsData;
import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class StackBarColumn
extends TableColumn {
    private static final long serialVersionUID = 1L;

    public StackBarColumn(AbstractRenderer renderer) {
        super(renderer);
        this.setCss("stackbar");
    }

    @Override
    public String getType() {
        return "STACKBAR";
    }

    @Override
    public Component createComponent(String id, IModel<ItemContext> model) {
        ItemContext context = (ItemContext)model.getObject();
        ArrayList<StatsData> values = new ArrayList<StatsData>();
        for (RendererItem r : this.items) {
            StatsData d = new StatsData();
            Object value = r.getValue(context);
            if (value == null) {
                value = 0.0;
            }
            d.setValue(value);
            d.setColor(r.getColor(context));
            if (!Strings.isNullOrEmpty((String)r.getTooltip())) {
                d.setTitle(r.getTooltip());
            } else {
                d.setTitle(r.getValueExpression());
            }
            values.add(d);
        }
        return new StackBarPanel(id, (IModel<List<? extends StatsData>>)Model.ofList(values));
    }
}

