/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.renderer.table.column;

import com.google.common.collect.Lists;
import com.pmease.quickbuild.plugin.report.engine.ReportHelper;
import com.pmease.quickbuild.plugin.report.engine.annotation.Alias;
import com.pmease.quickbuild.plugin.report.engine.datareport.ReportStats;
import com.pmease.quickbuild.plugin.report.engine.renderer.AbstractRenderer;
import com.pmease.quickbuild.plugin.report.engine.renderer.AbstractReportPanel;
import com.pmease.quickbuild.plugin.report.engine.renderer.ItemContext;
import com.pmease.quickbuild.plugin.report.engine.renderer.chart.pie.PieChartPanel;
import com.pmease.quickbuild.plugin.report.engine.renderer.item.RendererItem;
import com.pmease.quickbuild.plugin.report.engine.renderer.piechart.PieChartItem;
import com.pmease.quickbuild.plugin.report.engine.renderer.table.column.TableColumn;
import com.pmease.quickbuild.web.component.dashboardpanel.StatsData;
import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;

public class PieChartColumn
extends TableColumn {
    private static final long serialVersionUID = 1L;
    @Alias
    private int width = 140;
    @Alias
    private int height = 140;
    @Alias
    private boolean withLegend = true;
    @Alias
    private String noDataMessage;

    public PieChartColumn(AbstractRenderer renderer) {
        super(renderer);
        this.setMergeRow(true);
        this.setCss("chart-view");
    }

    @Override
    public String getType() {
        return "PIE_CHART";
    }

    @Override
    public Component createComponent(String id, final IModel<ItemContext> model) {
        LoadableDetachableModel<List<StatsData>> chartModel = new LoadableDetachableModel<List<StatsData>>(){
            private static final long serialVersionUID = 1L;

            protected List<StatsData> load() {
                ItemContext context = (ItemContext)model.getObject();
                AbstractReportPanel panel = context.getReportPanel();
                ReportStats stats = panel.getReportStats();
                ArrayList list = Lists.newArrayList();
                List<RendererItem> items = PieChartColumn.this.getItems();
                for (RendererItem each : items) {
                    PieChartItem item = (PieChartItem)each;
                    StatsData data = new StatsData();
                    data.setTitle(item.getTitle());
                    data.setColor(each.getColor(context));
                    data.setValue(ReportHelper.evaluate(each.getValueExpression(), stats.getStats()));
                    list.add(data);
                }
                return list;
            }
        };
        return new PieChartPanel(id, this.getWidth(), this.getHeight(), this.getNoDataMessage(), this.isWithLegend(), (IModel<List<StatsData>>)chartModel);
    }

    @Override
    protected RendererItem createDefaultItem() {
        return new PieChartItem(this.getRenderer());
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public boolean isWithLegend() {
        return this.withLegend;
    }

    public void setWithLegend(boolean withLegend) {
        this.withLegend = withLegend;
    }

    public String getNoDataMessage() {
        return this.noDataMessage;
    }

    public void setNoDataMessage(String noDataMessage) {
        this.noDataMessage = noDataMessage;
    }
}

