/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.renderer.table.column;

import com.google.common.base.Strings;
import com.pmease.quickbuild.plugin.report.engine.renderer.ItemContext;
import com.pmease.quickbuild.plugin.report.engine.renderer.table.column.TableColumn;
import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractColumn;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class GridColumn
extends AbstractColumn<ItemContext> {
    private static final long serialVersionUID = 1L;
    final TableColumn column;

    public GridColumn(TableColumn column) {
        super((IModel)Model.of((Serializable)((Object)column.getTitle())), column.getOrderBy());
        this.column = column;
    }

    public void populateItem(Item<ICellPopulator<ItemContext>> cellItem, String componentId, IModel<ItemContext> rowModel) {
        Component c = this.column.createComponent(componentId, rowModel).setRenderBodyOnly(true);
        cellItem.add(new Component[]{c});
    }

    public Component getHeader(String componentId) {
        Component label = new Label(componentId, this.getDisplayModel()).setEscapeModelStrings(false);
        if (!Strings.isNullOrEmpty((String)this.column.getTooltip())) {
            label.add(new Behavior[]{new AttributeAppender("title", (IModel)Model.of((Serializable)((Object)this.column.getTooltip())), ";")});
            label.add(new Behavior[]{new AttributeAppender("class", (IModel)Model.of((Serializable)((Object)"th-help")), " ")});
        }
        return label;
    }

    public String getCssClass() {
        return this.column.getCss();
    }

    public TableColumn getTableColumn() {
        return this.column;
    }
}

