/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.renderer.table.column;

import com.google.common.collect.Lists;
import com.pmease.quickbuild.plugin.report.engine.renderer.AbstractRenderer;
import com.pmease.quickbuild.plugin.report.engine.renderer.ItemContext;
import com.pmease.quickbuild.plugin.report.engine.renderer.table.column.CompositeColumnPanel;
import com.pmease.quickbuild.plugin.report.engine.renderer.table.column.TableColumn;
import com.pmease.quickbuild.plugin.report.engine.util.TypedObjects;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.model.IModel;
import org.dom4j.Element;

public class CompositeColumn
extends TableColumn {
    private static final long serialVersionUID = 1L;
    List<TableColumn> columns = Lists.newArrayList();

    public CompositeColumn(AbstractRenderer renderer) {
        super(renderer);
    }

    @Override
    public String getType() {
        return "COMPOSITE";
    }

    @Override
    public Component createComponent(String id, IModel<ItemContext> model) {
        CompositeColumnPanel panel = new CompositeColumnPanel(id, this, model);
        return panel.setRenderBodyOnly(true);
    }

    @Override
    public void fromXML(Element node) {
        super.fromXML(node);
        List nodes = node.elements("column");
        for (Element each : nodes) {
            TableColumn column = TypedObjects.createTypedObject(each, TableColumn.class, new TableColumn(this.getRenderer()), this.getRenderer());
            column.fromXML(each);
            this.addColumn(column);
        }
    }

    public List<TableColumn> getColumns() {
        return this.columns;
    }

    public void setColumns(List<TableColumn> columns) {
        this.columns = columns;
    }

    public void addColumn(TableColumn column) {
        this.columns.add(column);
    }
}

