/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.renderer.table;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataReport;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.datastore.Order;
import com.pmease.quickbuild.plugin.report.engine.datastore.SqlBuilder;
import com.pmease.quickbuild.plugin.report.engine.renderer.AbstractReportPanel;
import com.pmease.quickbuild.plugin.report.engine.renderer.ItemContext;
import com.pmease.quickbuild.plugin.report.engine.renderer.RendererContext;
import com.pmease.quickbuild.plugin.report.engine.renderer.table.TableRenderer;
import com.pmease.quickbuild.plugin.report.engine.renderer.table.column.GridColumn;
import com.pmease.quickbuild.plugin.report.engine.renderer.table.column.TableColumn;
import com.pmease.quickbuild.plugin.report.engine.renderer.table.datagrid.DataGrid;
import com.pmease.quickbuild.plugin.report.engine.renderer.table.datagrid.GroupableDataGrid;
import com.pmease.quickbuild.plugin.report.engine.renderer.table.provider.ReportDataProvider;
import com.pmease.quickbuild.plugin.report.engine.renderer.table.toolbar.BreadcrumbToolbar;
import com.pmease.quickbuild.plugin.report.engine.renderer.table.toolbar.FeedbackToolbar;
import com.pmease.quickbuild.plugin.report.engine.renderer.table.toolbar.ToolbarCreator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractToolbar;
import org.apache.wicket.extensions.markup.html.repeater.data.table.DataTable;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.NoRecordsToolbar;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class TableReportPanel
extends AbstractReportPanel {
    private static final long serialVersionUID = 1L;
    protected DataGrid dataGrid;
    protected final ReportDataProvider provider = this.createDataProvider();

    public TableReportPanel(String id, TableRenderer renderer, IModel<RendererContext> model) {
        super(id, renderer, model);
        this.dataGrid = this.createDataGrid("records");
        this.add(new Component[]{this.dataGrid});
        this.add(new Component[]{new WebMarkupContainer("emptySpan").setOutputMarkupId(true)});
    }

    @Override
    public void onInitialize() {
        super.onInitialize();
        this.addToolbars(this.dataGrid);
    }

    protected ReportDataProvider createDataProvider() {
        return new ReportDataProvider(this);
    }

    @Override
    protected String getDefaultScript() {
        return "$('#$gridId .jqhelp').animatetip({tipClass: 'fancytip fancyhelp'});";
    }

    @Override
    protected Map<String, Object> buildScriptContext() {
        Map<String, Object> context = super.buildScriptContext();
        context.put("gridId", this.dataGrid.getMarkupId());
        context.put("emptySpan", this.get("emptySpan").getMarkupId());
        return context;
    }

    protected DataGrid createDataGrid(String id) {
        DataGrid dataGrid = this.newDataGrid(id);
        if (!Strings.isNullOrEmpty((String)this.getRenderer().getCss())) {
            dataGrid.add(new Behavior[]{new AttributeAppender("class", (IModel)Model.of((Serializable)((Object)this.getRenderer().getCss())), " ")});
        }
        return dataGrid;
    }

    protected DataGrid newDataGrid(String id) {
        TableRenderer renderer = this.getRenderer();
        if (renderer.getGroupBy().length > 0) {
            return new GroupableDataGrid(id, this.getColumns(), this.provider, this);
        }
        return new DataGrid(id, this.getColumns(), this.provider, this);
    }

    public int getRowsPerPage() {
        int i = this.getRenderer().getRowsPerPage();
        if (i == 0) {
            return Integer.MAX_VALUE;
        }
        return i;
    }

    protected void addDefaultToolbars(DataGrid dataGrid) {
        String noRecordMessage = this.getRenderer().getNoRecordMessage();
        if (!this.isShowReports()) {
            noRecordMessage = "Report display is disabled";
        }
        if (Strings.isNullOrEmpty((String)noRecordMessage)) {
            dataGrid.addBottomToolbar((AbstractToolbar)new NoRecordsToolbar((DataTable)dataGrid));
        } else {
            dataGrid.addBottomToolbar((AbstractToolbar)new NoRecordsToolbar((DataTable)dataGrid, (IModel)Model.of((Serializable)((Object)noRecordMessage))));
        }
        dataGrid.addTopToolbar(new FeedbackToolbar(dataGrid));
        dataGrid.addTopToolbar(new BreadcrumbToolbar(dataGrid, this.getRenderer().isSortFilter()));
    }

    protected void addToolbars(DataGrid dataGrid) {
        this.addDefaultToolbars(dataGrid);
        TableRenderer renderer = this.getRenderer();
        for (ToolbarCreator each : renderer.getToolbars()) {
            each.create(dataGrid);
        }
    }

    protected List<IColumn<ItemContext>> getColumns() {
        Collection<TableColumn> defs = this.getTableColumns();
        ArrayList list = Lists.newArrayListWithCapacity((int)defs.size());
        for (TableColumn each : defs) {
            GridColumn column = new GridColumn(each);
            list.add(column);
        }
        return list;
    }

    protected Collection<TableColumn> getTableColumns() {
        return this.getRenderer().getColumns();
    }

    public Iterator<ItemContext> iterator(int first, int count) {
        DataReport report;
        long start = System.currentTimeMillis();
        DataReport passthrough = this.getContext().getPassthroughReport();
        List<Order> orders = this.provider.getOrders();
        if (passthrough != null) {
            if (!orders.isEmpty()) {
                passthrough.sortRows(orders);
            }
            int toIndex = Math.min(first + count, passthrough.getRowsCount());
            ArrayList rows = Lists.newArrayList(passthrough.getRows().subList(first, toIndex));
            report = passthrough.newInstance(false);
            report.setRows(rows);
        } else {
            SqlBuilder query = this.createQuery();
            query.limit(count);
            query.offset(first);
            if (!orders.isEmpty()) {
                query.clearOrderBy();
                query.orderby(orders);
            }
            report = this.loadReport(query);
        }
        List<DataRow> rows = report.getRows();
        ArrayList list = Lists.newArrayList();
        for (DataRow row : rows) {
            list.add(this.createItemContext(row));
        }
        if (Context.getLogger().isDebugEnabled()) {
            Context.getLogger().debug("Load data rows cost: " + (System.currentTimeMillis() - start) + " millis.");
        }
        return list.iterator();
    }

    public ItemContext createItemContext(DataRow row) {
        ItemContext context = new ItemContext();
        context.setDataRow(row);
        context.setReportPanel(this);
        context.setDataGrid(this.dataGrid);
        context.setExpressionContext(this.buildExpressionContext(row));
        context.setReportSet(this.getReportSet());
        context.setBuild(this.getBuild());
        context.setConfiguration(this.getConfiguration());
        return context;
    }

    public Map<String, Object> buildExpressionContext(DataRow row) {
        Map<String, Object> map = row.toMap();
        map.put("currentRow", row);
        return map;
    }

    @Override
    public TableRenderer getRenderer() {
        return (TableRenderer)super.getRenderer();
    }

    public DataGrid getDataGrid() {
        return this.dataGrid;
    }

    public ReportDataProvider getProvider() {
        return this.provider;
    }
}

