/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.renderer.table;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.pmease.quickbuild.plugin.report.engine.annotation.Alias;
import com.pmease.quickbuild.plugin.report.engine.exception.MalFormedXMLException;
import com.pmease.quickbuild.plugin.report.engine.exception.ReportException;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.renderer.AbstractRenderer;
import com.pmease.quickbuild.plugin.report.engine.renderer.ContainsOption;
import com.pmease.quickbuild.plugin.report.engine.renderer.RendererContext;
import com.pmease.quickbuild.plugin.report.engine.renderer.table.TableReportPanel;
import com.pmease.quickbuild.plugin.report.engine.renderer.table.column.TableColumn;
import com.pmease.quickbuild.plugin.report.engine.renderer.table.toolbar.ToolbarCreator;
import com.pmease.quickbuild.plugin.report.engine.util.TypedObjects;
import com.pmease.quickbuild.plugin.report.engine.util.XMLHelper;
import java.util.Collection;
import java.util.List;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.dom4j.Element;
import org.dom4j.Node;

public class TableRenderer
extends AbstractRenderer {
    private static final long serialVersionUID = 1L;
    public static TableRenderer NULL_RENDERER = new TableRenderer(ReportCategory.NULL_CATEGORY);
    @Alias
    private int rowsPerPage = 20;
    @Alias
    private String noRecordMessage;
    @Alias
    private boolean sortFilter = true;
    private ContainsOption containsOption;
    private List<TableColumn> columns = Lists.newArrayList();
    private List<ToolbarCreator> toolbars = Lists.newArrayList();
    private String groupRowTemplate;
    private String[] groupBy = new String[0];

    public TableRenderer(ReportCategory category) {
        super(category);
    }

    @Override
    public Panel createReportPanel(String panelId, IModel<RendererContext> model) {
        return new TableReportPanel(panelId, this, model);
    }

    public int getRowsPerPage() {
        return this.rowsPerPage;
    }

    public void setRowsPerPage(int rowsPerPage) {
        this.rowsPerPage = rowsPerPage;
    }

    @Override
    public String getType() {
        return "TABLE";
    }

    @Override
    public void fromXML(Element node) {
        boolean override;
        Element containElement;
        super.fromXML(node);
        List nodes = node.elements("column");
        for (Element each : nodes) {
            try {
                TableColumn column = TypedObjects.createTypedObject(each, TableColumn.class, new TableColumn(this), this);
                column.fromXML(each);
                this.addColumn(column);
            }
            catch (Exception e) {
                throw new MalFormedXMLException("Create renderer " + this.getId() + " failed due to: " + e.getMessage(), (Node)each);
            }
        }
        Element groupRow = node.element("groupRow");
        if (groupRow != null) {
            this.groupBy = XMLHelper.getStringArray((Node)groupRow, "groupBy");
            this.groupRowTemplate = XMLHelper.getString((Node)groupRow, "group-template");
        }
        if ((containElement = (Element)node.selectSingleNode("./search-options/search-option")) != null) {
            this.containsOption = new ContainsOption();
            this.containsOption.fromXML(containElement);
        }
        if (override = XMLHelper.getBoolean((Node)node, "./toolbars/@override", false).booleanValue()) {
            this.toolbars = Lists.newArrayList();
        }
        nodes = node.selectNodes("./toolbars/toolbar");
        for (Element each : nodes) {
            ToolbarCreator creator = TypedObjects.createTypedObject(each, ToolbarCreator.class, null, this);
            creator.fromXML(each);
            this.addToolbar(creator);
        }
    }

    public String[] getGroupBy() {
        if (this.groupBy == null) {
            return new String[0];
        }
        return this.groupBy;
    }

    public void setGroupBy(String[] groupBy) {
        this.groupBy = groupBy;
    }

    public String getGroupRowTemplate() {
        return this.groupRowTemplate;
    }

    public void setGroupRowTemplate(String groupRowTemplate) {
        this.groupRowTemplate = groupRowTemplate;
    }

    public String getNoRecordMessage() {
        return this.noRecordMessage;
    }

    public void setNoRecordMessage(String noRecordMessage) {
        this.noRecordMessage = noRecordMessage;
    }

    public void addColumn(TableColumn column) {
        this.columns.add(column);
    }

    public Collection<TableColumn> getColumns() {
        return ImmutableList.copyOf(this.columns);
    }

    public void setColumns(Collection<TableColumn> columns) {
        this.columns = Lists.newArrayList(columns);
    }

    public ContainsOption getContainsOption() {
        return this.containsOption;
    }

    public void setContainsOption(ContainsOption option) {
        this.containsOption = option;
    }

    public String getContainsColumns() {
        if (this.containsOption == null) {
            throw new ReportException("No contains option defined for renderer " + this);
        }
        return this.containsOption.getColumns();
    }

    public void addToolbar(ToolbarCreator toolbar) {
        this.toolbars.add(toolbar);
    }

    public List<ToolbarCreator> getToolbars() {
        return ImmutableList.copyOf(this.toolbars);
    }

    public void setToolbars(List<ToolbarCreator> toolbars) {
        this.toolbars = toolbars;
    }

    public boolean isSortFilter() {
        return this.sortFilter;
    }

    public void setSortFilter(boolean sortFilter) {
        this.sortFilter = sortFilter;
    }
}

