/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.renderer.summary;

import com.pmease.quickbuild.plugin.report.engine.annotation.Alias;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.renderer.AbstractRenderer;
import com.pmease.quickbuild.plugin.report.engine.renderer.RendererContext;
import com.pmease.quickbuild.plugin.report.engine.renderer.RendererMode;
import com.pmease.quickbuild.plugin.report.engine.renderer.summary.ReportSummaryPanel;
import com.pmease.quickbuild.plugin.report.engine.util.TypedObjects;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.dom4j.Element;

public class ReportSummaryRenderer
extends AbstractRenderer {
    private static final long serialVersionUID = 1L;
    @Alias
    private String template;
    private AbstractRenderer summaryRenderer;

    public ReportSummaryRenderer(ReportCategory category) {
        super(category);
        this.setMode(RendererMode.BUILD_SUMMARY);
    }

    @Override
    public String getType() {
        return "BUILD_SUMMARY";
    }

    @Override
    public Panel render(String id, IModel<RendererContext> model) {
        return this.createReportPanel(id, model);
    }

    @Override
    public Panel createReportPanel(String id, IModel<RendererContext> model) {
        return new ReportSummaryPanel(id, this, model);
    }

    @Override
    public void fromXML(Element node) {
        super.fromXML(node);
        Element rendererNode = node.element("renderer");
        if (rendererNode != null) {
            this.summaryRenderer = TypedObjects.createTypedObject(rendererNode, AbstractRenderer.class, null, this.getCategory());
            this.summaryRenderer.fromXML(rendererNode);
        }
    }

    public String getTemplate() {
        return this.template;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public AbstractRenderer getSummaryRenderer() {
        return this.summaryRenderer;
    }

    public void setSummaryRenderer(AbstractRenderer summaryRenderer) {
        this.summaryRenderer = summaryRenderer;
    }
}

