/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.renderer.summary;

import com.google.common.collect.Lists;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataColumn;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataReport;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.renderer.AbstractRenderer;
import com.pmease.quickbuild.plugin.report.engine.renderer.RendererContext;
import com.pmease.quickbuild.plugin.report.engine.renderer.summary.ReportSummaryRenderer;
import com.pmease.quickbuild.plugin.report.engine.util.ReportUtils;
import com.pmease.quickbuild.util.VelocityUtils;
import com.pmease.quickbuild.web.component.tabbedpanel.Tab;
import java.io.File;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.wicket.Component;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.AbstractLink;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;

public class ReportSummaryPanel
extends Panel {
    private static final long serialVersionUID = 1L;
    ReportSummaryRenderer renderer;

    public ReportSummaryPanel(String id, final ReportSummaryRenderer renderer, IModel<RendererContext> model) {
        super(id, model);
        this.renderer = renderer;
        AbstractLink titleLink = new AbstractLink("titleLink"){
            private static final long serialVersionUID = 1L;

            public void onComponentTag(ComponentTag tag) {
                super.onComponentTag(tag);
                tag.put("href", (CharSequence)("/build/" + ReportSummaryPanel.this.getBuild().getId() + "/" + Tab.title2id((String)renderer.getCategory().getName())));
            }
        };
        titleLink.add(new Component[]{new Label("title", renderer.getTitle())});
        this.add(new Component[]{titleLink});
        this.add(new Component[]{new ListView<String>("reportsets", (IModel)new LoadableDetachableModel<List<String>>(){
            private static final long serialVersionUID = 1L;

            protected List<String> load() {
                Build build = ReportSummaryPanel.this.getBuild();
                ReportCategory category = renderer.getCategory();
                return Lists.newArrayList((Object[])category.getReportSetsOfBuild(build));
            }
        }){
            private static final long serialVersionUID = 1L;

            protected void populateItem(ListItem<String> item) {
                String reportset = (String)item.getModelObject();
                int size = this.getList().size();
                Object subTitle = size == 1 && "DEFAULT".equalsIgnoreCase(reportset) ? new WebMarkupContainer("reportset").setVisible(false) : new Label("reportset", reportset);
                item.add(new Component[]{subTitle});
                Build build = ReportSummaryPanel.this.getBuild();
                AbstractRenderer summaryRenderer = renderer.getSummaryRenderer();
                if (summaryRenderer == null) {
                    Map<String, Object> context = ReportSummaryPanel.this.getReportStats(build, reportset);
                    if (context.isEmpty()) {
                        item.add(new Component[]{new WebMarkupContainer("content").setVisible(false)});
                        subTitle.setVisible(false);
                    } else {
                        context.put("BUILD_ID", build.getId());
                        context.put("REPORT_SET", reportset);
                        context.put("build", build);
                        context.put("utils", ReportUtils.getInstance());
                        context.put("category", renderer.getCategory());
                        String content = VelocityUtils.evalTemplate((String)renderer.getTemplate(), context);
                        item.add(new Component[]{new Label("content", content).setEscapeModelStrings(false)});
                    }
                } else {
                    RendererContext rc = new RendererContext(ReportSummaryPanel.this.getContext());
                    rc.setReportSet(reportset);
                    item.add(new Component[]{summaryRenderer.createReportPanel("content", (IModel<RendererContext>)Model.of((Serializable)rc))});
                }
            }
        }});
    }

    protected Map<String, Object> getReportStats(Build build, String reportset) {
        File dbDir;
        ReportCategory category = this.renderer.getCategory();
        DataReport report = category.loadReport(dbDir = category.getReportDirOfBuild(build, reportset), this.renderer.getDataSource());
        if (report.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        DataRow row = report.getRow(0);
        map.put("currentRow", row);
        for (DataColumn each : report.getMeta().getColumns()) {
            map.put(each.getColumnName(), row.getValue(each.getColumnName()));
        }
        return map;
    }

    protected Build getBuild() {
        return Context.getBuild();
    }

    protected RendererContext getContext() {
        return (RendererContext)this.getDefaultModelObject();
    }
}

