/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.renderer.statstable;

import com.google.common.collect.Lists;
import com.pmease.quickbuild.plugin.report.engine.annotation.Alias;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.renderer.AbstractRenderer;
import com.pmease.quickbuild.plugin.report.engine.renderer.RendererContext;
import com.pmease.quickbuild.plugin.report.engine.renderer.statstable.StatsRow;
import com.pmease.quickbuild.plugin.report.engine.renderer.statstable.StatsTablePanel;
import com.pmease.quickbuild.plugin.report.engine.util.TypedObjects;
import java.util.List;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.dom4j.Element;

public class StatsTableRenderer
extends AbstractRenderer {
    private static final long serialVersionUID = 1L;
    @Alias
    private boolean calcStats;
    @Alias
    private boolean displayTrend = true;
    private List<StatsRow> rows = Lists.newArrayList();

    public StatsTableRenderer(ReportCategory category) {
        super(category);
        this.setContentOnly(true);
    }

    @Override
    public void fromXML(Element node) {
        super.fromXML(node);
        List nodes = node.elements("row");
        for (Element each : nodes) {
            StatsRow row = TypedObjects.createTypedObject(each, StatsRow.class, new StatsRow(this), this);
            row.fromXML(each);
            this.rows.add(row);
        }
    }

    @Override
    public String getType() {
        return "STATS_TABLE";
    }

    @Override
    public Panel createReportPanel(String id, IModel<RendererContext> model) {
        return new StatsTablePanel(id, this, model);
    }

    public List<StatsRow> getRows() {
        return this.rows;
    }

    public void setRows(List<StatsRow> rows) {
        this.rows = rows;
    }

    public boolean isCalcStats() {
        return this.calcStats;
    }

    public void setCalcStats(boolean calcStats) {
        this.calcStats = calcStats;
    }

    public boolean isDisplayTrend() {
        return this.displayTrend;
    }

    public void setDisplayTrend(boolean displayTrend) {
        this.displayTrend = displayTrend;
    }
}

