/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.renderer.statstable;

import com.google.common.base.Strings;
import com.pmease.quickbuild.plugin.report.engine.renderer.ItemContext;
import com.pmease.quickbuild.plugin.report.engine.renderer.RendererContext;
import com.pmease.quickbuild.plugin.report.engine.renderer.dashboard.AbstractDashboardStatsPanel;
import com.pmease.quickbuild.plugin.report.engine.renderer.statstable.StatsRow;
import com.pmease.quickbuild.plugin.report.engine.renderer.statstable.StatsTableRenderer;
import com.pmease.quickbuild.plugin.report.engine.renderer.table.column.TableColumn;
import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class StatsTablePanel
extends AbstractDashboardStatsPanel {
    private static final long serialVersionUID = 1L;

    public StatsTablePanel(String id, StatsTableRenderer renderer, IModel<RendererContext> model) {
        super(id, renderer, model);
    }

    @Override
    public void onInitialize() {
        super.onInitialize();
        WebMarkupContainer span = new WebMarkupContainer("span");
        this.add(new Component[]{span});
        span.setOutputMarkupId(true);
        if (!Strings.isNullOrEmpty((String)this.renderer.getCss())) {
            span.add(new Behavior[]{new AttributeAppender("class", (IModel)Model.of((Serializable)((Object)this.renderer.getCss())), " ")});
        }
        span.add(new Component[]{this.createStatsTable("stats")});
    }

    protected Component createStatsTable(String id) {
        return new ListView<StatsRow>(id, this.getRenderer().getRows()){
            private static final long serialVersionUID = 1L;

            protected void populateItem(ListItem<StatsRow> item) {
                String css;
                StatsRow row = (StatsRow)item.getModelObject();
                item.add(new Component[]{new RowListView("columns", row).setRenderBodyOnly(true)});
                String string = css = item.getIndex() % 2 == 0 ? "even" : "odd";
                if (!Strings.isNullOrEmpty((String)row.getCss())) {
                    css = css + " " + row.getCss();
                }
                item.add(new Behavior[]{new AttributeAppender("class", (IModel)Model.of((Serializable)((Object)css)), " ")});
            }
        };
    }

    @Override
    public StatsTableRenderer getRenderer() {
        return (StatsTableRenderer)super.getRenderer();
    }

    @Override
    protected boolean isCalcStats() {
        return this.getRenderer().isCalcStats();
    }

    @Override
    protected boolean isLoadPrevious() {
        return this.getRenderer().isDisplayTrend();
    }

    private class RowListView
    extends ListView<TableColumn> {
        private static final long serialVersionUID = 1L;

        public RowListView(String id, StatsRow row) {
            super(id, row.getColumns());
        }

        protected void populateItem(ListItem<TableColumn> item) {
            TableColumn column = (TableColumn)item.getModelObject();
            item.add(new Component[]{column.createComponent("column", (IModel<ItemContext>)StatsTablePanel.this.contextModel)});
            if (!Strings.isNullOrEmpty((String)column.getCss())) {
                item.add(new Behavior[]{new AttributeAppender("class", (IModel)Model.of((Serializable)((Object)column.getCss())), " ")});
            }
        }
    }
}

