/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.renderer.statstable;

import com.google.common.collect.Lists;
import com.pmease.quickbuild.plugin.report.engine.annotation.Alias;
import com.pmease.quickbuild.plugin.report.engine.metadata.AbstractCategoryItem;
import com.pmease.quickbuild.plugin.report.engine.renderer.AbstractRenderer;
import com.pmease.quickbuild.plugin.report.engine.renderer.table.column.TableColumn;
import com.pmease.quickbuild.plugin.report.engine.util.TypedObjects;
import java.util.List;
import org.dom4j.Element;

public class StatsRow
extends AbstractCategoryItem {
    private static final long serialVersionUID = 1L;
    @Alias
    private String css;
    private List<TableColumn> columns = Lists.newArrayList();
    private final AbstractRenderer renderer;

    public StatsRow(AbstractRenderer renderer) {
        super(renderer.getCategory());
        this.renderer = renderer;
    }

    protected TableColumn createDefaultColumn() {
        return new TableColumn(this.renderer);
    }

    @Override
    public void fromXML(Element node) {
        super.fromXML(node);
        List nodes = node.elements("column");
        for (Element each : nodes) {
            TableColumn column = TypedObjects.createTypedObject(each, TableColumn.class, this.createDefaultColumn(), this.renderer);
            column.fromXML(each);
            this.columns.add(column);
        }
    }

    @Override
    public String getType() {
        return "DEFAULT";
    }

    @Override
    public String getElementName() {
        return "row";
    }

    public List<TableColumn> getColumns() {
        return this.columns;
    }

    public void setColumns(List<TableColumn> columns) {
        this.columns = columns;
    }

    public AbstractRenderer getRenderer() {
        return this.renderer;
    }

    public String getCss() {
        return this.css;
    }

    public void setCss(String css) {
        this.css = css;
    }
}

