/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.renderer.statistics;

import com.google.common.base.Strings;
import com.pmease.quickbuild.plugin.report.engine.datatype.DataTypes;
import com.pmease.quickbuild.plugin.report.engine.datatype.DurationType;
import com.pmease.quickbuild.plugin.report.engine.datatype.IntegerType;
import com.pmease.quickbuild.plugin.report.engine.datatype.LongType;
import com.pmease.quickbuild.plugin.report.engine.datatype.PercentType;
import com.pmease.quickbuild.plugin.report.engine.extensionpoint.DataType;
import com.pmease.quickbuild.plugin.report.engine.renderer.CompareOption;
import com.pmease.quickbuild.plugin.report.engine.renderer.chart.line.LineChartData;
import com.pmease.quickbuild.plugin.report.engine.renderer.statistics.StatisticsPanel;
import com.pmease.quickbuild.plugin.report.engine.web.event.AjaxEvent;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;

public class StatsSummaryPanel
extends Panel {
    private static final long serialVersionUID = 1L;
    final StatisticsPanel parentPanel;

    public StatsSummaryPanel(String id, final StatisticsPanel parentPanel) {
        super(id);
        this.parentPanel = parentPanel;
        this.setOutputMarkupId(true);
        this.add(new Component[]{new SummaryView("averages", (IModel<List<LineChartData>>)new AbstractReadOnlyModel<List<LineChartData>>(){
            private static final long serialVersionUID = 1L;

            public List<LineChartData> getObject() {
                return parentPanel.getLineChart().getChartSeries();
            }
        })});
    }

    protected String getSummaryUnit(LineChartData data) {
        DataType dataType = data.getDataType();
        if (dataType instanceof DurationType) {
            return "(average)";
        }
        if (dataType instanceof PercentType) {
            return "/build";
        }
        return data.getSetting().getItem().getTitle() + "/build";
    }

    public void onEvent(IEvent<?> sink) {
        if (sink.getPayload() instanceof AjaxEvent) {
            ((AjaxEvent)sink.getPayload()).getTarget().add(new Component[]{this});
        }
    }

    class SummaryView
    extends ListView<LineChartData> {
        private static final long serialVersionUID = 1L;

        public SummaryView(String id, IModel<List<LineChartData>> model) {
            super(id, model);
        }

        protected void populateItem(ListItem<LineChartData> item) {
            LineChartData data = (LineChartData)item.getModelObject();
            DataType dataType = data.getDataType();
            double average = data.getAverage();
            String title = null;
            if (StatsSummaryPanel.this.parentPanel.isCompareToPast()) {
                title = data.getSetting().getDateRange().format("MMM dd, yyyy");
            } else if (StatsSummaryPanel.this.parentPanel.getChartOption().getCompareOption() == CompareOption.OTHER_CONFIGURATION) {
                title = "Configuration: " + data.getSetting().getTitle();
            }
            if (Strings.isNullOrEmpty((String)title)) {
                item.add(new Component[]{new WebMarkupContainer("title").setVisible(false)});
            } else {
                item.add(new Component[]{new Label("title", title)});
            }
            DataType averageType = dataType;
            if (dataType instanceof IntegerType || dataType instanceof LongType && !(dataType instanceof DurationType)) {
                averageType = DataTypes.DOUBLE;
            }
            item.add(new Component[]{new Label("averageValue", averageType.asString(average))});
            String unit = StatsSummaryPanel.this.getSummaryUnit(data);
            item.add(new Component[]{new Label("averageUnit", unit)});
            item.add(new Component[]{new Label("summary", data.getSummaryInfo())});
        }
    }
}

