/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.renderer.statistics;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.pmease.quickbuild.plugin.report.engine.ReportConstants;
import com.pmease.quickbuild.plugin.report.engine.datatype.BooleanType;
import com.pmease.quickbuild.plugin.report.engine.datatype.DataTypes;
import com.pmease.quickbuild.plugin.report.engine.datatype.EnumType;
import com.pmease.quickbuild.plugin.report.engine.datatype.PercentType;
import com.pmease.quickbuild.plugin.report.engine.extensionpoint.DataType;
import com.pmease.quickbuild.plugin.report.engine.renderer.GroupOption;
import com.pmease.quickbuild.plugin.report.engine.renderer.chart.line.LineChart;
import com.pmease.quickbuild.plugin.report.engine.renderer.chart.line.LineChartData;
import com.pmease.quickbuild.plugin.report.engine.renderer.chart.line.LineChartItem;
import com.pmease.quickbuild.plugin.report.engine.renderer.statistics.StatisticsPanel;
import com.pmease.quickbuild.plugin.report.engine.util.BuildFragment;
import com.pmease.quickbuild.plugin.report.engine.util.ReportUtils;
import com.pmease.quickbuild.plugin.report.engine.web.ColorBarWithLabel;
import com.pmease.quickbuild.plugin.report.engine.web.event.AjaxEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.velocity.runtime.parser.node.MathUtils;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;

public class StatsDetailsPanel
extends Panel {
    private static final long serialVersionUID = 1L;
    final StatisticsPanel parentPanel;

    public StatsDetailsPanel(String id, StatisticsPanel parentPanel) {
        super(id);
        this.parentPanel = parentPanel;
        this.setOutputMarkupId(true);
        this.setVersioned(false);
        this.add(new Component[]{new VariableBar("hbars", (IModel<List<HBarItem>>)new LoadableDetachableModel<List<HBarItem>>(){
            private static final long serialVersionUID = 1L;

            protected List<HBarItem> load() {
                return StatsDetailsPanel.this.createHBarItems();
            }
        })});
    }

    private List<HBarItem> createHBarItems() {
        LineChart lineChart = this.parentPanel.getLineChart();
        ArrayList barItems = Lists.newArrayList();
        List<LineChartData> series = lineChart.getChartSeries();
        GroupOption groupOption = this.parentPanel.getChartOption().getGroupOption();
        LineChartData primary = series.get(0);
        int count = primary.size();
        boolean hasGroup = series.size() > 1 && !this.parentPanel.isCompareToPast();
        for (int i = count - 1; i >= 0 && barItems.size() <= 1000; --i) {
            if (this.parentPanel.getChartOption().isIgnoreNoBuildDays() && primary.getItem(i).getTotalBuilds() <= 0) continue;
            if (hasGroup) {
                HBarItem barItem = new HBarItem();
                LineChartItem chartItem = primary.getItem(i);
                if (groupOption == GroupOption.BY_VERSION) {
                    barItem.setBarLabel(chartItem.getFromBuild().getVersion());
                } else {
                    barItem.setBarLabel(chartItem.getDateRange().format("EEEEE, MMMMM dd, yyyy"));
                }
                barItems.add(barItem);
            }
            for (int j = 0; j < series.size(); ++j) {
                LineChartData chartData = series.get(j);
                HBarItem barItem = new HBarItem();
                barItems.add(barItem);
                barItem.setReportIndex(j);
                LineChartItem chartItem = null;
                if (i < chartData.size()) {
                    chartItem = chartData.getItem(i);
                }
                if (hasGroup) {
                    barItem.setBarLabel(chartData.getSetting().getTitle());
                } else if (chartItem != null) {
                    if (groupOption == GroupOption.BY_VERSION) {
                        barItem.setBarLabel(chartItem.getFromBuild().getVersion());
                    } else {
                        barItem.setBarLabel(chartItem.getDateRange().format("EEEEE, MMMMM dd, yyyy"));
                    }
                }
                if (chartItem == null || chartItem.getValidBuilds() == 0) {
                    barItem.setBarPercent(0.0);
                    barItem.setBarText("");
                    continue;
                }
                DataType dataType = chartData.getSetting().getItem().getDataType();
                if (dataType instanceof BooleanType || dataType instanceof EnumType) {
                    dataType = DataTypes.PERCENT;
                }
                double value = chartItem.getValue();
                double max = lineChart.getRange(dataType).getMax();
                double percent = dataType instanceof PercentType ? value : (MathUtils.isZero((Number)max) ? 0.0 : value / max);
                StringBuffer sb = new StringBuffer();
                sb.append(dataType.asString(value));
                if (groupOption != GroupOption.BY_VERSION && this.parentPanel.isShowBuildInfo()) {
                    sb.append(" <span class='light-text'>");
                    if (chartItem.getValidBuilds() > 0) {
                        BuildFragment from = chartItem.getFromBuild();
                        BuildFragment to = chartItem.getToBuild();
                        sb.append(ReportUtils.hyperlinkBuild(from));
                        if (!Objects.equal((Object)from, (Object)to)) {
                            sb.append("-").append(ReportUtils.hyperlinkBuild(to));
                        }
                    }
                    sb.append(" (").append(chartItem.getSucceeded()).append(" successed, ").append(chartItem.getFailed()).append(" failed)");
                    sb.append("</span>");
                }
                barItem.setBarPercent(percent);
                barItem.setBarText(sb.toString());
            }
        }
        return barItems;
    }

    public void onEvent(IEvent<?> sink) {
        if (sink.getPayload() instanceof AjaxEvent) {
            this.onEvent((AjaxEvent)sink.getPayload());
        }
    }

    public void onEvent(AjaxEvent event) {
        event.getTarget().add(new Component[]{this});
    }

    private class VariableBar
    extends ListView<HBarItem> {
        private static final long serialVersionUID = 1L;

        public VariableBar(String id, IModel<List<HBarItem>> list) {
            super(id, list);
        }

        protected void populateItem(ListItem<HBarItem> item) {
            HBarItem barItem = (HBarItem)item.getModelObject();
            int reportsTotal = StatsDetailsPanel.this.parentPanel.getLineChart().size();
            if (reportsTotal == 1 || StatsDetailsPanel.this.parentPanel.isCompareToPast()) {
                Label groupTitle = new Label("groupTitle", barItem.getBarLabel());
                groupTitle.add(new Behavior[]{new AttributeModifier("title", (IModel)Model.of((Serializable)((Object)barItem.getBarLabel())))});
                item.add(new Component[]{groupTitle});
                if (barItem.getReportIndex() == 1) {
                    groupTitle.add(new Behavior[]{new AttributeModifier("style", (IModel)Model.of((Serializable)((Object)"color: #FF9900;")))});
                }
                item.add(new Component[]{new ColorBarWithLabel("hbar", barItem.getBarPercent(), ReportConstants.COLORS[barItem.getReportIndex()], barItem.getBarText(), "", true)});
            } else {
                Label groupTitle = new Label("groupTitle", barItem.getBarLabel());
                groupTitle.add(new Behavior[]{new AttributeModifier("title", (IModel)Model.of((Serializable)((Object)barItem.getBarLabel())))});
                item.add(new Component[]{groupTitle});
                int index = item.getIndex() % (reportsTotal + 1);
                if (index == 0) {
                    groupTitle.add(new Behavior[]{new AttributeModifier("class", (IModel)Model.of((Serializable)((Object)"title")))});
                    item.add(new Component[]{new WebMarkupContainer("hbar").setVisible(false)});
                } else {
                    item.add(new Component[]{new ColorBarWithLabel("hbar", barItem.getBarPercent(), ReportConstants.COLORS[index - 1], barItem.getBarText(), "", true)});
                }
            }
        }
    }

    private class HBarItem
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String barLabel;
        private double barPercent;
        private String barText;
        private int reportIndex;

        public String getBarLabel() {
            return this.barLabel;
        }

        public void setBarLabel(String barLabel) {
            this.barLabel = barLabel;
        }

        public double getBarPercent() {
            return this.barPercent;
        }

        public void setBarPercent(double barPercent) {
            this.barPercent = barPercent;
        }

        public String getBarText() {
            return this.barText;
        }

        public void setBarText(String barText) {
            this.barText = barText;
        }

        public int getReportIndex() {
            return this.reportIndex;
        }

        public void setReportIndex(int reportIndex) {
            this.reportIndex = reportIndex;
        }
    }
}

