/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.renderer.statistics;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.pmease.quickbuild.plugin.report.engine.annotation.Alias;
import com.pmease.quickbuild.plugin.report.engine.contribution.web.StatisticsReportTab;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.renderer.AbstractRenderer;
import com.pmease.quickbuild.plugin.report.engine.renderer.RendererContext;
import com.pmease.quickbuild.plugin.report.engine.renderer.statistics.SimpleStatisticsPanel;
import com.pmease.quickbuild.plugin.report.engine.renderer.statistics.StatisticsItem;
import com.pmease.quickbuild.plugin.report.engine.renderer.statistics.StatisticsPanel;
import com.pmease.quickbuild.plugin.report.engine.util.TypedObjects;
import com.pmease.quickbuild.web.component.tabbedpanel.Tab;
import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.dom4j.Element;

public class StatisticsRenderer
extends AbstractRenderer {
    private static final long serialVersionUID = 1L;
    private List<StatisticsItem> items = Lists.newArrayList();
    @Alias
    private boolean simpleMode = false;

    public StatisticsRenderer(ReportCategory category) {
        super(category);
    }

    @Override
    public String getType() {
        return "STATISTICS";
    }

    @Override
    public Panel render(String id, IModel<RendererContext> model) {
        return this.createReportPanel(id, model);
    }

    @Override
    public Panel createReportPanel(String id, IModel<RendererContext> model) {
        if (this.isSimpleMode()) {
            return new SimpleStatisticsPanel(id, this, model);
        }
        return new StatisticsPanel(id, this, model);
    }

    public List<Tab> getContributeTabs() {
        ArrayList tabs = Lists.newArrayList();
        for (StatisticsItem item : this.getItems()) {
            tabs.add(new StatisticsReportTab(this, item));
        }
        return tabs;
    }

    public boolean hasItem(StatisticsItem item) {
        for (StatisticsItem each : this.getItems()) {
            if (!Objects.equal((Object)each, (Object)item)) continue;
            return true;
        }
        return false;
    }

    public List<StatisticsItem> getItems() {
        return this.items;
    }

    public void setItems(List<StatisticsItem> items) {
        this.items = items;
    }

    public StatisticsItem findItem(String valueExpression) {
        for (StatisticsItem each : this.getItems()) {
            if (!valueExpression.equalsIgnoreCase(each.getValueExpression())) continue;
            return each;
        }
        return null;
    }

    @Override
    public void fromXML(Element node) {
        super.fromXML(node);
        List nodes = node.elements("item");
        for (Element each : nodes) {
            StatisticsItem item = TypedObjects.createTypedObject(each, StatisticsItem.class, new StatisticsItem(this.getCategory()), this.getCategory());
            item.setReportName(this.getMeta().getReportName());
            item.fromXML(each);
            this.items.add(item);
        }
    }

    public boolean isSimpleMode() {
        return this.simpleMode;
    }

    public void setSimpleMode(boolean simpleMode) {
        this.simpleMode = simpleMode;
    }
}

