/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.renderer.statistics;

import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.pmease.quickbuild.plugin.report.engine.ReportHelper;
import com.pmease.quickbuild.plugin.report.engine.datatype.BooleanType;
import com.pmease.quickbuild.plugin.report.engine.datatype.DataTypes;
import com.pmease.quickbuild.plugin.report.engine.datatype.EnumType;
import com.pmease.quickbuild.plugin.report.engine.extensionpoint.DataType;
import com.pmease.quickbuild.plugin.report.engine.renderer.ExportFormat;
import com.pmease.quickbuild.plugin.report.engine.renderer.GroupOption;
import com.pmease.quickbuild.plugin.report.engine.renderer.RendererContext;
import com.pmease.quickbuild.plugin.report.engine.renderer.SessionData;
import com.pmease.quickbuild.plugin.report.engine.renderer.chart.line.LineChart;
import com.pmease.quickbuild.plugin.report.engine.renderer.chart.line.LineChartData;
import com.pmease.quickbuild.plugin.report.engine.renderer.chart.line.LineChartItem;
import com.pmease.quickbuild.plugin.report.engine.renderer.statistics.AbstractStatisticsPanel;
import com.pmease.quickbuild.plugin.report.engine.renderer.statistics.GraphControls;
import com.pmease.quickbuild.plugin.report.engine.renderer.statistics.LineChartPanel;
import com.pmease.quickbuild.plugin.report.engine.renderer.statistics.StatisticsHeaderPanel;
import com.pmease.quickbuild.plugin.report.engine.renderer.statistics.StatisticsItem;
import com.pmease.quickbuild.plugin.report.engine.renderer.statistics.StatisticsRenderer;
import com.pmease.quickbuild.plugin.report.engine.renderer.statistics.StatsDetailsPanel;
import com.pmease.quickbuild.plugin.report.engine.renderer.statistics.StatsExtraControls;
import com.pmease.quickbuild.plugin.report.engine.renderer.statistics.StatsSummaryPanel;
import com.pmease.quickbuild.plugin.report.engine.renderer.statistics.event.ChartOptionChanged;
import com.pmease.quickbuild.plugin.report.engine.renderer.statistics.event.CompareOptionChanged;
import com.pmease.quickbuild.plugin.report.engine.renderer.statistics.event.GroupOptionChanged;
import com.pmease.quickbuild.plugin.report.engine.util.XMLHelper;
import com.pmease.quickbuild.plugin.report.engine.util.csv.CSVWriter;
import com.pmease.quickbuild.plugin.report.engine.web.LinkPanel;
import com.pmease.quickbuild.plugin.report.engine.web.event.AjaxEvent;
import com.pmease.quickbuild.plugin.report.engine.web.event.DateRangeChanged;
import com.pmease.quickbuild.plugin.report.engine.web.event.ReportSetChanged;
import com.pmease.quickbuild.util.FileUtils;
import com.pmease.quickbuild.web.behavior.menu.MenuBehavior;
import com.pmease.quickbuild.web.behavior.menu.MenuItem;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AbstractDefaultAjaxBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.EnclosureContainer;
import org.apache.wicket.markup.html.link.AbstractLink;
import org.apache.wicket.markup.html.link.DownloadLink;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.cycle.RequestCycle;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class StatisticsPanel
extends AbstractStatisticsPanel {
    private static final long serialVersionUID = 1L;

    public StatisticsPanel(String id, StatisticsRenderer renderer, IModel<RendererContext> model) {
        super(id, renderer, model);
    }

    protected void onInitialize() {
        super.onInitialize();
        this.add(new Component[]{new WebMarkupContainer("msgDisabled").setVisibilityAllowed(!ReportHelper.isShowReports(this.renderer.getCategory()))});
        WebMarkupContainer statspan = new WebMarkupContainer("statspan");
        statspan.setOutputMarkupId(true);
        this.add(new Component[]{statspan});
        Component widthSpan = new WebMarkupContainer("widthSpan").setOutputMarkupId(true);
        widthSpan.add(new Behavior[]{new AbstractDefaultAjaxBehavior(){
            private static final long serialVersionUID = 1L;

            protected CharSequence getCallbackScript() {
                return this.generateCallbackScript("wicketAjaxGet('" + this.getCallbackUrl() + "&ChartWidth=' + chartwidth");
            }

            public void renderHead(Component component, IHeaderResponse response) {
                super.renderHead(component, response);
                response.renderOnLoadJavaScript(this.getWidthScript());
            }

            private String getWidthScript() {
                StringBuffer script = new StringBuffer();
                script.append("var chartwidth = $('#").append(this.getComponent().getMarkupId()).append("').width();");
                script.append(this.getCallbackScript());
                return script.toString();
            }

            protected void respond(AjaxRequestTarget target) {
                StatisticsPanel.this.chartWidth = RequestCycle.get().getRequest().getQueryParameters().getParameterValue("ChartWidth").toInt(750);
                ContentFrag c = new ContentFrag("statspan");
                c.setOutputMarkupId(true);
                StatisticsPanel.this.addOrReplace(new Component[]{c});
                target.add(new Component[]{c});
                target.appendJavaScript((CharSequence)StatisticsPanel.this.loadJavaScript());
            }
        }});
        this.add(new Component[]{widthSpan});
    }

    protected Component createStatsHeader(String id) {
        return new StatisticsHeaderPanel(id, this);
    }

    protected Component createGraphControls(String id) {
        return new GraphControls(id, this);
    }

    protected Component createChartGraph(String id) {
        return new LineChartPanel(id, this);
    }

    protected Component createExtraControls(String id) {
        return new StatsExtraControls(id, this);
    }

    protected Component createStatsSummary(String id) {
        return new StatsSummaryPanel(id, this);
    }

    protected Component createStatsDetails(String id) {
        return new StatsDetailsPanel(id, this);
    }

    protected void addComponents(WebMarkupContainer statspan) {
        Component header = this.createStatsHeader("statsHeader");
        if (header == null) {
            header = new WebMarkupContainer("statsHeader").setVisible(false);
        } else {
            header.setOutputMarkupId(true);
        }
        EnclosureContainer e1 = new EnclosureContainer("headerContainer", header);
        e1.add(new Component[]{header});
        statspan.addOrReplace(new Component[]{e1});
        Component statsControls = this.createGraphControls("statsControls");
        if (statsControls == null) {
            statsControls = new WebMarkupContainer("statsControls").setVisible(false);
        } else {
            statsControls.setOutputMarkupId(true);
        }
        EnclosureContainer e2 = new EnclosureContainer("controlsContainer", statsControls);
        e2.add(new Component[]{statsControls});
        statspan.addOrReplace(new Component[]{e2});
        Component statsGraph = this.createChartGraph("statsGraph");
        if (statsGraph == null) {
            statsGraph = new WebMarkupContainer("statsGraph").setVisible(false);
        } else {
            statsGraph.setOutputMarkupId(true);
        }
        EnclosureContainer e3 = new EnclosureContainer("graphContainer", statsGraph);
        e3.add(new Component[]{statsGraph});
        statspan.addOrReplace(new Component[]{e3});
        Component extraControls = this.createExtraControls("extraControls");
        if (extraControls == null) {
            extraControls = new WebMarkupContainer("extraControls").setVisible(false);
        }
        EnclosureContainer e4 = new EnclosureContainer("extraControlsContainer", extraControls);
        e4.add(new Component[]{extraControls});
        statspan.addOrReplace(new Component[]{e4});
        Component statsSummary = this.createStatsSummary("statsSummary");
        if (statsSummary == null) {
            statsSummary = new WebMarkupContainer("statsSummary").setVisible(false);
        }
        EnclosureContainer e5 = new EnclosureContainer("summaryContainer", statsSummary);
        e5.add(new Component[]{statsSummary});
        statspan.addOrReplace(new Component[]{e5});
        Component statsDetails = this.createStatsDetails("statsDetails");
        if (statsDetails == null) {
            statsDetails = new WebMarkupContainer("statsDetails").setVisible(false);
        }
        EnclosureContainer e6 = new EnclosureContainer("detailsContainer", statsDetails);
        e6.add(new Component[]{statsDetails});
        statspan.addOrReplace(new Component[]{e6});
    }

    public String getTitle() {
        return this.getPrimaryItem().getTitle();
    }

    public List<String> getLegends() {
        ArrayList legends = Lists.newArrayList();
        LineChart lineChart = this.getLineChart();
        for (LineChartData each : lineChart.getChartSeries()) {
            legends.add(each.getSetting().getTitle());
        }
        return legends;
    }

    public Long getPrimaryConfigId() {
        return this.getConfiguration().getId();
    }

    public List<StatisticsItem> getComparableFields() {
        List<StatisticsItem> items = this.renderer.getItems();
        ArrayList<StatisticsItem> comparableFields = new ArrayList<StatisticsItem>();
        for (StatisticsItem item : items) {
            if (item == this.getChartOption().getPrimaryItem()) continue;
            comparableFields.add(item);
        }
        return comparableFields;
    }

    public boolean hasExcludingFailed() {
        return true;
    }

    public Component createExportLink(String id) {
        AbstractLink link = new AbstractLink(id){};
        link.add(new Behavior[]{new MenuBehavior(){

            protected List<MenuItem> getMenuItems() {
                ArrayList items = Lists.newArrayList();
                for (ExportFormat each : ExportFormat.values()) {
                    items.add(new ExportMenuItem(each));
                }
                return items;
            }
        }});
        return link;
    }

    protected Map<String, Object> buildScriptContext() {
        String markupId = this.getMarkupId();
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("panelId", markupId);
        return context;
    }

    protected String loadJavaScript() {
        StringBuffer sb = new StringBuffer();
        sb.append("$('#").append(this.getMarkupId()).append(" .bar').each(function() {var w = $(this).attr('rel'); $(this).animate({width: w});});");
        String script = this.renderer.getScript();
        if (!Strings.isNullOrEmpty((String)script)) {
            sb.append(script);
        }
        if (!Strings.isNullOrEmpty((String)(script = sb.toString()))) {
            script = ReportHelper.evaluateVelocity(script, this.buildScriptContext());
            sb = new StringBuffer();
            sb.append(script);
            return sb.toString();
        }
        return null;
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        String javascript = this.loadJavaScript();
        if (!Strings.isNullOrEmpty((String)javascript)) {
            // empty if block
        }
    }

    public void onEvent(IEvent<?> sink) {
        Object payload = sink.getPayload();
        if (payload instanceof ReportSetChanged) {
            this.onEvent((ReportSetChanged)payload);
        } else if (payload instanceof AjaxEvent) {
            this.onAjaxEvent((AjaxEvent)payload);
        }
    }

    private void onAjaxEvent(AjaxEvent event) {
        String script = this.loadJavaScript();
        event.getTarget().appendJavaScript((CharSequence)script);
        if (this.isByVersionDisabled() && this.chartOption.getGroupOption() == GroupOption.BY_VERSION) {
            this.chartOption.setGroupOption(GroupOption.BY_DAY);
        }
        SessionData.get().setLineChartOption(this.chartOption);
    }

    public void onEvent(ReportSetChanged event) {
        this.onAjaxEvent(event);
        this.setReportSet(event.getReportset());
        SessionData.get().setReportSet(event.getReportset());
    }

    public void onEvent(ChartOptionChanged event) {
        this.onAjaxEvent(event);
    }

    public void onEvent(CompareOptionChanged event) {
        this.onAjaxEvent(event);
    }

    public void onEvent(GroupOptionChanged event) {
        this.onAjaxEvent(event);
    }

    public void onEvent(DateRangeChanged event) {
        this.onAjaxEvent(event);
    }

    private class ContentFrag
    extends Fragment {
        private static final long serialVersionUID = 1L;

        public ContentFrag(String id) {
            super(id, "frag", (MarkupContainer)StatisticsPanel.this);
        }

        protected void onInitialize() {
            super.onInitialize();
            Component header = StatisticsPanel.this.createStatsHeader("statsHeader");
            if (header == null) {
                header = new WebMarkupContainer("statsHeader").setVisible(false);
            } else {
                header.setOutputMarkupId(true);
            }
            EnclosureContainer e1 = new EnclosureContainer("headerContainer", header);
            e1.add(new Component[]{header});
            this.add(new Component[]{e1});
            Component statsControls = StatisticsPanel.this.createGraphControls("statsControls");
            if (statsControls == null) {
                statsControls = new WebMarkupContainer("statsControls").setVisible(false);
            } else {
                statsControls.setOutputMarkupId(true);
            }
            EnclosureContainer e2 = new EnclosureContainer("controlsContainer", statsControls);
            e2.add(new Component[]{statsControls});
            this.add(new Component[]{e2});
            Component statsGraph = StatisticsPanel.this.createChartGraph("statsGraph");
            if (statsGraph == null) {
                statsGraph = new WebMarkupContainer("statsGraph").setVisible(false);
            } else {
                statsGraph.setOutputMarkupId(true);
            }
            EnclosureContainer e3 = new EnclosureContainer("graphContainer", statsGraph);
            e3.add(new Component[]{statsGraph});
            this.add(new Component[]{e3});
            Component extraControls = StatisticsPanel.this.createExtraControls("extraControls");
            if (extraControls == null) {
                extraControls = new WebMarkupContainer("extraControls").setVisible(false);
            }
            EnclosureContainer e4 = new EnclosureContainer("extraControlsContainer", extraControls);
            e4.add(new Component[]{extraControls});
            this.add(new Component[]{e4});
            Component statsSummary = StatisticsPanel.this.createStatsSummary("statsSummary");
            if (statsSummary == null) {
                statsSummary = new WebMarkupContainer("statsSummary").setVisible(false);
            }
            EnclosureContainer e5 = new EnclosureContainer("summaryContainer", statsSummary);
            e5.add(new Component[]{statsSummary});
            this.add(new Component[]{e5});
            Component statsDetails = StatisticsPanel.this.createStatsDetails("statsDetails");
            if (statsDetails == null) {
                statsDetails = new WebMarkupContainer("statsDetails").setVisible(false);
            }
            EnclosureContainer e6 = new EnclosureContainer("detailsContainer", statsDetails);
            e6.add(new Component[]{statsDetails});
            this.add(new Component[]{e6});
        }
    }

    private class ExportMenuItem
    extends MenuItem {
        private final ExportFormat format;

        ExportMenuItem(ExportFormat format) {
            this.format = format;
        }

        public Component render(String componentId) {
            return new LinkPanel(componentId, (IModel)Model.of((Serializable)((Object)this.format.name())), true){

                @Override
                protected AbstractLink createLink(String id) {
                    return new DownloadLink(id, ExportMenuItem.this.getFileModel(), StatisticsPanel.this.getRenderer().getCategory().getId() + "-stats." + ExportMenuItem.this.format.name().toLowerCase()).setDeleteAfterDownload(true);
                }
            };
        }

        private IModel<File> getFileModel() {
            return new LoadableDetachableModel<File>(){

                protected File load() {
                    File tmp = FileUtils.createTempFile((String)"chart", (String)ExportMenuItem.this.format.name().toLowerCase());
                    LineChart chart = StatisticsPanel.this.getLineChart();
                    if (chart != null) {
                        switch (ExportMenuItem.this.format) {
                            case XML: {
                                Document doc = DocumentHelper.createDocument((Element)chart.toXML());
                                XMLHelper.writeXML(doc, tmp);
                                break;
                            }
                            case CSV: {
                                ExportMenuItem.this.writeCSV(chart, tmp, ',');
                                break;
                            }
                            case TSV: {
                                ExportMenuItem.this.writeCSV(chart, tmp, '\t');
                            }
                        }
                    }
                    return tmp;
                }
            };
        }

        private void writeCSV(LineChart chart, File file, char delim) {
            GroupOption groupOption = StatisticsPanel.this.getChartOption().getGroupOption();
            List<LineChartData> series = chart.getChartSeries();
            LineChartData primary = series.get(0);
            int count = primary.size();
            FileWriter fw = null;
            try {
                fw = new FileWriter(file);
                CSVWriter w = new CSVWriter(fw, delim);
                ArrayList fields = Lists.newArrayList();
                if (StatisticsPanel.this.isCompareToPast()) {
                    fields.add("Current");
                    fields.add("Past");
                    fields.add("Current Value");
                    fields.add("Past Value");
                } else {
                    if (groupOption == GroupOption.BY_VERSION) {
                        fields.add("Version");
                    } else if (groupOption == GroupOption.BY_DAY) {
                        fields.add("Day");
                    } else if (groupOption == GroupOption.BY_WEEK) {
                        fields.add("Week");
                    } else {
                        fields.add("Month");
                    }
                    for (int j = 0; j < series.size(); ++j) {
                        LineChartData chartData = series.get(j);
                        fields.add(chartData.getSetting().getTitle());
                    }
                }
                w.writeLine(fields);
                if (StatisticsPanel.this.isCompareToPast()) {
                    LineChartData past = series.get(1);
                    for (int i = count - 1; i >= 0; --i) {
                        ArrayList values = Lists.newArrayList();
                        if (groupOption == GroupOption.BY_VERSION) {
                            values.add(primary.getItem(i).getFromBuild().getVersion());
                            if (i < past.size()) {
                                values.add(past.getItem(i).getFromBuild().getVersion());
                            } else {
                                values.add("");
                            }
                        } else {
                            values.add(primary.getItem(i).getDateRange().format("MMM dd, yyyy"));
                            if (i < past.size()) {
                                values.add(past.getItem(i).getDateRange().format("MMM dd, yyyy"));
                            } else {
                                values.add("");
                            }
                        }
                        DataType dataType = primary.getSetting().getItem().getDataType();
                        if (dataType instanceof BooleanType || dataType instanceof EnumType) {
                            dataType = DataTypes.PERCENT;
                        }
                        double value = primary.getItem(i).getValue();
                        values.add(dataType.asString(value));
                        if (past.size() > i) {
                            values.add(dataType.asString(past.getItem(i).getValue()));
                        } else {
                            values.add("");
                        }
                        w.writeLine(values);
                    }
                } else {
                    for (int i = count - 1; i >= 0; --i) {
                        if (StatisticsPanel.this.getChartOption().isIgnoreNoBuildDays() && primary.getItem(i).getTotalBuilds() <= 0) continue;
                        ArrayList values = Lists.newArrayList();
                        if (groupOption == GroupOption.BY_VERSION) {
                            values.add(primary.getItem(i).getFromBuild().getVersion());
                        } else {
                            values.add(primary.getItem(i).getDateRange().format("MMM dd, yyyy"));
                        }
                        for (int j = 0; j < series.size(); ++j) {
                            LineChartData chartData = series.get(j);
                            LineChartItem chartItem = null;
                            if (i < chartData.size()) {
                                chartItem = chartData.getItem(i);
                            }
                            if (chartItem == null || chartItem.getValidBuilds() == 0) {
                                values.add("");
                                continue;
                            }
                            DataType dataType = chartData.getSetting().getItem().getDataType();
                            if (dataType instanceof BooleanType || dataType instanceof EnumType) {
                                dataType = DataTypes.PERCENT;
                            }
                            double value = chartItem.getValue();
                            values.add(dataType.asString(value));
                        }
                        w.writeLine(values);
                    }
                }
                fw.flush();
            }
            catch (IOException e) {
                try {
                    throw Throwables.propagate((Throwable)e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(fw);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((Writer)fw);
        }
    }
}

