/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.renderer.statistics;

import com.google.common.base.Strings;
import com.pmease.quickbuild.plugin.report.engine.annotation.Alias;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataColumn;
import com.pmease.quickbuild.plugin.report.engine.datareport.ReportMetaData;
import com.pmease.quickbuild.plugin.report.engine.datatype.BooleanType;
import com.pmease.quickbuild.plugin.report.engine.datatype.EnumType;
import com.pmease.quickbuild.plugin.report.engine.extensionpoint.DataType;
import com.pmease.quickbuild.plugin.report.engine.metadata.AbstractCategoryItem;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.util.TypedObjects;
import com.pmease.quickbuild.plugin.report.engine.util.XMLHelper;
import org.apache.wicket.util.lang.Objects;
import org.dom4j.Element;
import org.dom4j.Node;

public class StatisticsItem
extends AbstractCategoryItem {
    private static final long serialVersionUID = 1L;
    @Alias
    private String reportName;
    @Alias
    private boolean useAverage = true;
    @Alias
    private String tabName;
    @Alias
    private String title;
    @Alias(name="value")
    private String valueExpression;
    @Alias
    private String color;
    private DataType dataType;

    public StatisticsItem(ReportCategory category) {
        super(category);
    }

    public StatisticsItem(StatisticsItem other) {
        super(other.category);
        this.reportName = other.reportName;
        this.useAverage = other.useAverage;
        this.tabName = other.tabName;
        this.title = other.title;
        this.valueExpression = other.valueExpression;
        this.color = other.color;
        this.dataType = other.getDataType();
    }

    @Override
    public String getType() {
        return "STATISTICS";
    }

    @Override
    public void fromXML(Element node) {
        String str;
        super.fromXML(node);
        if (Strings.isNullOrEmpty((String)this.title)) {
            this.title = this.tabName;
        }
        this.dataType = !Strings.isNullOrEmpty((String)(str = XMLHelper.getString((Node)node, "dataType"))) ? TypedObjects.createTypedObject(str, DataType.class, new Object[0]) : this.getColumn().getDataType();
        if (this.dataType instanceof BooleanType || this.dataType instanceof EnumType) {
            this.useAverage = true;
        }
    }

    public boolean isByVersionDisabled() {
        DataType dataType = this.getDataType();
        return dataType instanceof BooleanType || dataType instanceof EnumType;
    }

    public boolean isUseAverage() {
        return this.useAverage;
    }

    public void setUseAverage(boolean useAverage) {
        this.useAverage = useAverage;
    }

    public String getTabName() {
        return this.tabName;
    }

    public void setTabName(String tabName) {
        this.tabName = tabName;
    }

    public String getTitle() {
        if (Strings.isNullOrEmpty((String)this.title)) {
            return this.tabName;
        }
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getReportName() {
        return this.reportName;
    }

    public void setReportName(String reportName) {
        this.reportName = reportName;
    }

    public String getValueExpression() {
        return this.valueExpression;
    }

    public void setValueExpression(String valueExpression) {
        this.valueExpression = valueExpression;
    }

    public String getColor() {
        return this.color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    @Override
    public String getElementName() {
        return "item";
    }

    public ReportMetaData getMeta() {
        return this.category.getMeta(this.reportName);
    }

    private DataColumn getColumn() {
        return this.getMeta().getColumn(this.valueExpression);
    }

    public DataType getDataType() {
        if (this.dataType == null) {
            return this.getColumn().getDataType();
        }
        return this.dataType;
    }

    public void setDataType(DataType dataType) {
        this.dataType = dataType;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !(other instanceof StatisticsItem)) {
            return false;
        }
        StatisticsItem rhs = (StatisticsItem)other;
        return Objects.equal((Object)this.category, (Object)rhs.category) && Objects.equal((Object)this.reportName, (Object)rhs.reportName) && Objects.equal((Object)this.tabName, (Object)rhs.tabName) && Objects.equal((Object)this.valueExpression, (Object)rhs.valueExpression);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.reportName, this.tabName, this.valueExpression});
    }
}

