/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.report.engine.renderer.statistics;

import com.google.common.collect.Lists;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.renderer.SessionData;
import com.pmease.quickbuild.plugin.report.engine.renderer.statistics.DateRangeFormPanel;
import com.pmease.quickbuild.plugin.report.engine.renderer.statistics.StatisticsPanel;
import com.pmease.quickbuild.plugin.report.engine.renderer.statistics.event.ChartOptionChanged;
import com.pmease.quickbuild.plugin.report.engine.renderer.statistics.event.CompareOptionChanged;
import com.pmease.quickbuild.plugin.report.engine.web.ChoicesLink;
import com.pmease.quickbuild.plugin.report.engine.web.event.DateRangeChanged;
import com.pmease.quickbuild.plugin.report.engine.web.event.ReportSetChanged;
import com.pmease.quickbuild.plugin.report.engine.web.jquery.JQConfirmLink;
import com.pmease.quickbuild.security.ConfigurationPermission;
import com.pmease.quickbuild.security.SecurityHelper;
import com.pmease.quickbuild.web.page.configuration.StatisticsPage;
import java.io.Serializable;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class StatisticsHeaderPanel
extends Panel {
    private static final long serialVersionUID = 1L;
    protected final StatisticsPanel parentPanel;

    public StatisticsHeaderPanel(String id, final StatisticsPanel parentPanel) {
        super(id);
        this.parentPanel = parentPanel;
        this.setOutputMarkupId(true);
        this.add(new Component[]{new Label("mainTitle", (IModel)new AbstractReadOnlyModel<String>(){
            private static final long serialVersionUID = 1L;

            public String getObject() {
                return parentPanel.getTitle();
            }
        }).setEscapeModelStrings(false).setOutputMarkupId(true)});
        this.add(new Component[]{new WebMarkupContainer("detailTitle").setVisible(false)});
        this.add(new Component[]{new Label("primaryDateRange", (IModel)new AbstractReadOnlyModel<String>(){
            private static final long serialVersionUID = 1L;

            public String getObject() {
                return SessionData.get().getLineChartOption().getPrimaryDateRange().format("MMM dd, yyyy");
            }
        })});
        WebMarkupContainer comparisonContainer = new WebMarkupContainer("comparisonContainer"){
            private static final long serialVersionUID = 1L;

            protected void onConfigure() {
                super.onConfigure();
                this.setVisible(parentPanel.isCompareToPast());
            }
        };
        this.add(new Component[]{comparisonContainer});
        comparisonContainer.add(new Component[]{new Label("compareState", (IModel)new AbstractReadOnlyModel<String>(){
            private static final long serialVersionUID = 1L;

            public String getObject() {
                return parentPanel.getChartOption().getComparisonDateRange().format("MMM dd, yyyy");
            }
        })});
        this.add(new Component[]{new DateRangeFormPanel("dateRangeForm", parentPanel)});
        AbstractReadOnlyModel<String> choiceModel = new AbstractReadOnlyModel<String>(){
            private static final long serialVersionUID = 1L;

            public String getObject() {
                return parentPanel.getReportSet();
            }
        };
        AbstractReadOnlyModel<List<String>> choicesModel = new AbstractReadOnlyModel<List<String>>(){
            private static final long serialVersionUID = 1L;

            public List<String> getObject() {
                return Lists.newArrayList((Object[])parentPanel.getReportSets());
            }
        };
        this.add(new Component[]{new ChoicesLink<String>("reportsets", (IModel)choiceModel, (IModel)choicesModel){
            private static final long serialVersionUID = 1L;

            @Override
            public void onChoiceChanged(AjaxRequestTarget target, String obj) {
                this.send((IEventSink)parentPanel, Broadcast.BREADTH, new ReportSetChanged(target, obj));
            }

            public void onConfigure() {
                super.onConfigure();
                this.setVisibilityAllowed(StatisticsHeaderPanel.this.hasMultipleReportSet());
            }
        }});
        this.add(new Component[]{parentPanel.createExportLink("exportLink")});
        this.add(new Component[]{this.createDeleteLink("deleteLink")});
        this.add(new Component[]{this.createDeleteAllLink("deleteAllLink")});
    }

    protected Component createDeleteLink(String id) {
        return new JQConfirmLink<Void>(id, (IModel)Model.of((Serializable)((Object)("Are you sure you want to delete the report set: " + this.parentPanel.getReportSet() + "?")))){
            private static final long serialVersionUID = 1L;

            public void onClick(AjaxRequestTarget target) {
                ReportCategory category = StatisticsHeaderPanel.this.parentPanel.getRenderer().getCategory();
                category.deleteReportSetOfStats(StatisticsHeaderPanel.this.parentPanel.getConfiguration(), StatisticsHeaderPanel.this.parentPanel.getReportSet());
                String[] reportsets = StatisticsHeaderPanel.this.parentPanel.getReportSets();
                if (reportsets.length == 0) {
                    this.setResponsePage((Page)new StatisticsPage(Context.getConfiguration().getId()));
                } else {
                    SessionData.get().setReportSet(reportsets[0]);
                    this.send((IEventSink)StatisticsHeaderPanel.this.parentPanel, Broadcast.BREADTH, new ReportSetChanged(target, reportsets[0]));
                }
            }

            public void onConfigure() {
                super.onConfigure();
                this.setVisibilityAllowed(SecurityHelper.hasPermission((String)ConfigurationPermission.DELETE_REPORT.name()) && StatisticsHeaderPanel.this.hasDeleteButtons() && StatisticsHeaderPanel.this.parentPanel.getReportSets().length > 0);
            }
        };
    }

    protected Component createDeleteAllLink(String id) {
        return new JQConfirmLink<Void>("deleteAllLink", (IModel)Model.of((Serializable)((Object)"Are you sure you want to permanent delete all report sets?"))){
            private static final long serialVersionUID = 1L;

            public void onClick(AjaxRequestTarget target) {
                ReportCategory category = StatisticsHeaderPanel.this.parentPanel.getRenderer().getCategory();
                category.deleteAllReportSetsOfStats(Context.getConfiguration());
                this.setResponsePage((Page)new StatisticsPage(Context.getConfiguration().getId()));
            }

            public void onConfigure() {
                super.onConfigure();
                this.setVisibilityAllowed(SecurityHelper.hasPermission((String)ConfigurationPermission.DELETE_REPORT.name()) && StatisticsHeaderPanel.this.hasDeleteButtons() && StatisticsHeaderPanel.this.hasMultipleReportSet());
            }
        };
    }

    public boolean hasDeleteButtons() {
        return true;
    }

    public void onEvent(ReportSetChanged event) {
        event.getTarget().add(new Component[]{this});
    }

    public void onEvent(CompareOptionChanged event) {
        event.getTarget().add(new Component[]{this});
    }

    public void onEvent(ChartOptionChanged event) {
        event.getTarget().add(new Component[]{this.get("mainTitle")});
    }

    public void onEvent(DateRangeChanged event) {
        event.getTarget().add(new Component[]{this});
    }

    protected boolean hasMultipleReportSet() {
        String[] reportsets = this.parentPanel.getReportSets();
        return reportsets != null && reportsets.length > 1;
    }
}

